<?xml version="1.0" encoding="iso-8859-1" ?>
<!-- $Revision: 126 $ -->

<refentry id="{@id}.intro">
<refnamediv>
    <refname>Introduction</refname>
    <refpurpose>
        File_Fortune provides an OOP interface for reading and manipulating *nix
        fortune cookie files. 
    </refpurpose>
</refnamediv>

<refsect1 id="{@id}.intro.description">
    <title>Description</title>
    <para>
        The <emphasis>fortune</emphasis> program is a small but important part
        of *nix culture, and this package aims to provide support for its
        "fortune cookie" databases to PHP programmers.
    </para>

    <para>
        For efficiency, all versions of <emphasis>fortune</emphasis> rely on a
        binary header consisting mainly of offsets into the fortune file proper.
        Modern versions of fortune keep this header in a separate file, and this
        is the style adopted by this package; the older style of munging the
        header and data into one large "compiled" file is not currently
        supported, and never will be.
    </para>

    <para>
        Using File_Fortune makes it trivial to write a simplified version of the
        <emphasis>fortune</emphasis> program:
    </para>
    <programlisting role="php">
    <![CDATA[
<?php
    // Trivial 'fortune' program
    $fortuneFile = $_SERVER['argv'][1];
    $fortunes    = new File_Fortune($fortuneFile);
    echo $fortunes->getRandom();
?>
    ]]>
    </programlisting>
    <para>
        (A more robust example of this may be found in the
        File/Fortune/examples/phpFortune script provided with this package.)
    </para>

    <para>
        The original <emphasis>fortune</emphasis> program provides additional
        features, such as parallel databases of offensive fortunes, selection of
        long or short fortunes, dealing with multiple fortune files, etc. These
        features are not currently available with this package, but may be
        included in future releases.
    </para>

    <para>
        File_Fortune implements Iterator, Countable, and ArrayAccess, which
        allow you to loop over the fortunes, count them easily, and access them
        in array notation, respectively. This provides a flexible mechanism with
        which you may maintain your <emphasis>fortune</emphasis> databases.
    </para>

    <para>
        Finally, you may create <emphasis>fortune</emphasis> databases using
        File_Fortune's <emphasis>create()</emphasis> method. Fortune files
        created with this mechanism are binary compatible with those used by the
        fortune utility and may be read both with File_Fortune as well as
        <emphasis>fortune</emphasis>.
    </para>
</refsect1>

<refsect1 id="{@id}.intro.usage1">
    <title>Usage Example 1: Retrieve a random fortune</title>
    <programlisting role="php">
    <![CDATA[
<?php
    require_once 'File/Fortune.php';
    try {
        $fortunes   = new File_Fortune('/path/to/fortune/file');
        echo $fortunes->getRandom();
    } catch (File_Fortune_Exception $e) {
        echo "An error occurred: " . $e->getMessage;
    }
?>
    ]]>
    </programlisting>
</refsect1>

<refsect1 id="{@id}.intro.usage1a">
    <title>Usage Example 1a: Retrieve a random fortune from a directory of
        fortune files</title>
    <programlisting role="php">
    <![CDATA[
<?php
    require_once 'File/Fortune.php';
    try {
        $fortunes = new File_Fortune('/path/to/fortunes/directory');
        echo $fortunes->getRandom();
    } catch (File_Fortune_Exception $e) {
        echo "An error occurred: " . $e->getMessage;
    }
?>
    ]]>
    </programlisting>
</refsect1>

<refsect1 id="{@id}.intro.usage2">
    <title>Usage Example 2: Retrieve a specific fortune</title>
    <programlisting role="php">
    <![CDATA[
<?php
    require_once 'File/Fortune.php';
    try {
        $fortunes   = new File_Fortune('/path/to/fortune/file');
        echo $fortunes[3];
    } catch (File_Fortune_Exception $e) {
        echo "An error occurred: " . $e->getMessage;
    }
?>
    ]]>
    </programlisting>
</refsect1>

<refsect1 id="{@id}.intro.usage3">
    <title>Usage Example 3: Write a fortune file from an array of fortunes</title>
    <programlisting role="php">
    <![CDATA[
<?php
    require_once 'File/Fortune.php';
    $newFortunes = array(
        'A thousand mile journey begins with a single step.',
        'cd /pub ; more beer',
        'We apologize for the inconvenience'
    );
    $fortunes = new File_Fortune();
    try {
        $fortunes->create($newFortunes, '/path/to/fortune/file');
    } catch (File_Fortune_Exception $e) {
        echo "An error occurred: " . $e->getMessage;
    }
?>
    ]]>
    </programlisting>
</refsect1>

<refsect1 id="{@id}.intro.usage4">
    <title>Usage Example 4: Add a fortune to an existing file</title>
    <programlisting role="php">
    <![CDATA[
<?php
    require_once 'File/Fortune.php';
    try {
        $fortunes = new File_Fortune('/path/to/fortune/file');
        $fortunes->add("There's no place like 127.0.0.1");
    } catch (File_Fortune_Exception $e) {
        echo "An error occurred: " . $e->getMessage;
    }
?>
    ]]>
    </programlisting>
</refsect1>

<refsect1 id="{@id}.intro.usage5">
    <title>Usage Example 5: Update a fortune in an existing file</title>
    <programlisting role="php">
    <![CDATA[
<?php
    require_once 'File/Fortune.php';
    try {
        $fortunes = new File_Fortune('/path/to/fortune/file');
        $fortunes[2] = 'mv /can/spam /dev/null';
    } catch (File_Fortune_Exception $e) {
        echo "An error occurred: " . $e->getMessage;
    }
?>
    ]]>
    </programlisting>
</refsect1>

<refsect1 id="{@id}.intro.usage6">
    <title>Usage Example 6: Delete a fortune from a file</title>
    <programlisting role="php">
    <![CDATA[
<?php
    require_once 'File/Fortune.php';
    try {
        $fortunes = new File_Fortune('/path/to/fortune/file');
        unset($fortunes[3]);
    } catch (File_Fortune_Exception $e) {
        echo "An error occurred: " . $e->getMessage;
    }
?>
    ]]>
    </programlisting>
</refsect1>

</refentry>
<!-- Keep this comment at the end of the file
Local variables:
mode: sgml
sgml-omittag:t
sgml-shorttag:t
sgml-minimize-attributes:nil
sgml-always-quote-attributes:t
sgml-indent-step:1
sgml-indent-data:t
sgml-parent-document:nil
sgml-default-dtd-file:"../../../../../manual.ced"
sgml-exposed-tags:nil
sgml-local-catalogs:nil
sgml-local-ecat-files:nil
End:
vim: ft=xml:
-->
