/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.multitouch;

import com.sparshui.gestures.GestureType;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3f;
import org.jmol.api.Interface;
import org.jmol.api.JmolTouchSimulatorInterface;
import org.jmol.multitouch.JmolMultiTouchAdapter;
import org.jmol.multitouch.JmolMultiTouchClient;
import org.jmol.util.Logger;
import org.jmol.viewer.ActionManager;
import org.jmol.viewer.Viewer;
import org.jmol.viewer.binding.Binding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionManagerMT
extends ActionManager
implements JmolMultiTouchClient {
    private JmolMultiTouchAdapter adapter;
    private JmolTouchSimulatorInterface simulator;
    private int groupID;
    private int simulationPhase;
    private boolean resetNeeded = true;
    private long lastLogTime = 0L;
    private boolean doneHere;
    public static final int DRAG_GESTURE = 0;
    public static final int MULTI_POINT_DRAG_GESTURE = 1;
    public static final int ROTATE_GESTURE = 2;
    public static final int SPIN_GESTURE = 3;
    public static final int TOUCH_GESTURE = 4;
    public static final int ZOOM_GESTURE = 5;
    public static final int DBLCLK_GESTURE = 6;
    public static final int FLICK_GESTURE = 7;
    public static final int RELATIVE_DRAG_GESTURE = 8;
    public static final int INVALID_GESTURE = 9;
    private static final GestureType TWO_POINT_GESTURE = new GestureType("org.jmol.multitouch.sparshui.TwoPointGesture");
    private static final GestureType SINGLE_POINT_GESTURE = new GestureType("org.jmol.multitouch.sparshui.SinglePointGesture");
    public static final int DRIVER_NONE = -2;
    public static final int SERVICE_LOST = -1;
    public static final int DRAG_EVENT = 0;
    public static final int ROTATE_EVENT = 1;
    public static final int SPIN_EVENT = 2;
    public static final int TOUCH_EVENT = 3;
    public static final int ZOOM_EVENT = 4;
    public static final int DBLCLK_EVENT = 5;
    public static final int FLICK_EVENT = 6;
    public static final int RELATIVE_DRAG_EVENT = 7;
    public static final int CLICK_EVENT = 8;
    private static final String[] eventNames = new String[]{"drag", "rotate", "spin", "touch", "zoom", "double-click", "flick", "relative-drag", "click"};
    public static final int BIRTH = 0;
    public static final int DEATH = 1;
    public static final int MOVE = 2;
    public static final int CLICK = 3;
    boolean mouseDown;

    public void setViewer(Viewer viewer, String string) {
        super.setViewer(viewer, string);
        this.groupID = (int)(Math.random() * 1.6777215E7) << 4;
        this.mouseWheelFactor = 1.02f;
        boolean bl = string.indexOf("-multitouch-sparshui") >= 0;
        boolean bl2 = string.indexOf("-multitouch-sparshui-simulated") >= 0;
        boolean bl3 = string.indexOf("-multitouch-jni") >= 0;
        String string2 = bl ? "multitouch.sparshui.JmolSparshClientAdapter" : "multitouch.jni.JmolJniClientAdapter";
        this.adapter = (JmolMultiTouchAdapter)Interface.getOptionInterface((String)string2);
        Logger.info((String)("ActionManagerMT SparshUI groupID=" + this.groupID));
        if (bl) {
            this.startSparshUIService(bl2);
        } else if (bl3) {
            this.adapter.setMultiTouchClient(viewer, this, false);
        }
        this.setBinding(this.binding);
        this.xyRange = 10;
    }

    private void startSparshUIService(boolean bl) {
        this.haveMultiTouchInput = false;
        if (this.adapter == null) {
            return;
        }
        if (this.simulator != null) {
            this.simulator.dispose();
            this.simulator = null;
        }
        if (bl) {
            Logger.error((String)"ActionManagerMT -- for now just using touch simulation.\nPress CTRL-LEFT and then draw two traces on the window.");
        }
        this.isMultiTouchClient = this.adapter.setMultiTouchClient(this.viewer, this, bl);
        this.isMultiTouchServer = this.adapter.isServer();
        if (bl) {
            this.simulator = (JmolTouchSimulatorInterface)Interface.getInterface((String)"com.sparshui.inputdevice.JmolTouchSimulator");
            if (this.simulator != null) {
                Logger.info((String)"ActionManagerMT simulating SparshUI");
                this.simulator.startSimulator((Component)this.viewer.getDisplay());
            }
        }
    }

    protected void setBinding(Binding binding) {
        super.setBinding(binding);
        this.binding.unbindMouseAction(4);
        if (this.simulator != null && this.binding != null) {
            this.binding.unbindJmolAction(0);
            this.binding.unbind(274, null);
            this.binding.bind(274, 45);
        }
    }

    public void clear() {
        this.simulationPhase = 0;
        this.resetNeeded = true;
        super.clear();
    }

    public void dispose() {
        Logger.debug((String)"ActionManagerMT -- dispose");
        this.doneHere = true;
        this.adapter.dispose();
        if (this.simulator != null) {
            this.simulator.dispose();
        }
        super.dispose();
    }

    private static String getEventName(int n) {
        try {
            return eventNames[n];
        }
        catch (Exception exception) {
            return "?";
        }
    }

    @Override
    public List<GestureType> getAllowedGestures(int n) {
        if (n != this.groupID || !this.viewer.allowMultiTouch()) {
            return null;
        }
        ArrayList<GestureType> arrayList = new ArrayList<GestureType>();
        arrayList.add(TWO_POINT_GESTURE);
        arrayList.add(SINGLE_POINT_GESTURE);
        return arrayList;
    }

    @Override
    public int getGroupID(int n, int n2) {
        int n3 = 0;
        try {
            if (this.viewer.hasFocus() && n >= 0 && n2 >= 0 && n < this.viewer.getScreenWidth() && n2 < this.viewer.getScreenHeight()) {
                n3 = this.groupID;
            }
            if (this.resetNeeded) {
                n3 |= 0x10000000;
                this.resetNeeded = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n3;
    }

    @Override
    public void processEvent(int n, int n2, int n3, int n4, Point3f point3f, long l) {
        if (Logger.debugging) {
            Logger.info((String)(this + " time=" + l + " groupID=" + n + " " + Integer.toHexString(n) + " eventType=" + n2 + "(" + ActionManagerMT.getEventName(n2) + ") iData=" + n4 + " pt=" + point3f));
        }
        switch (n2) {
            case -2: {
                if (this.simulator == null) {
                    this.haveMultiTouchInput = false;
                }
                Logger.error((String)"SparshUI reports no driver present");
                this.viewer.log("SparshUI reports no driver present -- setting haveMultiTouchInput FALSE");
                break;
            }
            case -1: {
                this.viewer.log("Jmol SparshUI client reports service lost -- " + (this.doneHere ? "not " : "") + " restarting");
                if (this.doneHere) break;
                this.startSparshUIService(this.simulator != null);
                break;
            }
            case 3: {
                this.haveMultiTouchInput = true;
                if (n3 == Integer.MAX_VALUE) {
                    this.mouseDown = false;
                    this.clearMouseInfo();
                    break;
                }
                switch (n4) {
                    case 0: {
                        this.mouseDown = true;
                        super.mousePressed(l, (int)point3f.x, (int)point3f.y, 16);
                        break;
                    }
                    case 2: {
                        if (this.mouseDown) {
                            super.mouseDragged(l, (int)point3f.x, (int)point3f.y, 16);
                            break;
                        }
                        super.mouseMoved(l, (int)point3f.x, (int)point3f.y, 16);
                        break;
                    }
                    case 1: {
                        this.mouseDown = false;
                        super.mouseReleased(l, (int)point3f.x, (int)point3f.y, 16);
                        break;
                    }
                    case 3: {
                        super.mouseClicked(l, (int)point3f.x, (int)point3f.y, 16, 1);
                    }
                }
                break;
            }
            case 4: {
                float f = point3f.z;
                if (f != -1.0f && f != 1.0f) break;
                this.zoomByFactor((int)f, Integer.MAX_VALUE, Integer.MAX_VALUE);
                this.logEvent("Zoom", point3f);
                break;
            }
            case 1: {
                this.checkMotion(3);
                this.viewer.rotateZBy((int)point3f.z, Integer.MAX_VALUE, Integer.MAX_VALUE);
                this.logEvent("Rotate", point3f);
                break;
            }
            case 0: {
                if (n4 != 2) break;
                this.checkMotion(3);
                this.viewer.translateXYBy((int)point3f.x, (int)point3f.y);
                this.logEvent("Drag", point3f);
            }
        }
    }

    private void logEvent(String string, Point3f point3f) {
        if (!this.viewer.getLogGestures()) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - this.lastLogTime > 10000L) {
            this.viewer.log("$NOW$ multitouch " + string + " pt= " + point3f);
            this.lastLogTime = l;
        }
    }

    public void mouseEntered(long l, int n, int n2) {
        super.mouseEntered(l, n, n2);
    }

    public void mouseExited(long l, int n, int n2) {
        super.mouseExited(l, n, n2);
    }

    public void mouseClicked(long l, int n, int n2, int n3, int n4) {
        if (this.haveMultiTouchInput) {
            return;
        }
        super.mouseClicked(l, n, n2, n3, n4);
    }

    public void mouseMoved(long l, int n, int n2, int n3) {
        if (this.haveMultiTouchInput) {
            return;
        }
        this.adapter.mouseMoved(n, n2);
        super.mouseMoved(l, n, n2, n3);
    }

    public void mouseWheel(long l, int n, int n2) {
        if (this.haveMultiTouchInput) {
            return;
        }
        super.mouseWheel(l, n, n2);
    }

    public void mousePressed(long l, int n, int n2, int n3) {
        if (this.simulator != null) {
            int n4 = Binding.getMouseAction((int)1, (int)n3);
            if (this.binding.isBound(n4, 45)) {
                this.setCurrent(0L, n, n2, n3);
                this.viewer.setFocus();
                if (this.simulationPhase++ == 0) {
                    this.simulator.startRecording();
                }
                this.simulator.mousePressed(l, n, n2);
                return;
            }
            this.simulationPhase = 0;
        }
        if (this.haveMultiTouchInput) {
            return;
        }
        super.mousePressed(l, n, n2, n3);
    }

    public void mouseDragged(long l, int n, int n2, int n3) {
        if (this.simulator != null && this.simulationPhase > 0) {
            this.setCurrent(l, n, n2, n3);
            this.simulator.mouseDragged(l, n, n2);
            return;
        }
        if (this.haveMultiTouchInput) {
            return;
        }
        super.mouseDragged(l, n, n2, n3);
    }

    public void mouseReleased(long l, int n, int n2, int n3) {
        if (this.simulator != null && this.simulationPhase > 0) {
            this.setCurrent(l, n, n2, n3);
            this.viewer.spinXYBy(0, 0, 0.0f);
            this.simulator.mouseReleased(l, n, n2);
            if (this.simulationPhase >= 2) {
                this.resetNeeded = true;
                this.simulator.endRecording();
                this.simulationPhase = 0;
            }
            return;
        }
        if (this.haveMultiTouchInput) {
            return;
        }
        super.mouseReleased(l, n, n2, n3);
    }

    protected float getExitRate() {
        long l = this.dragGesture.getTimeDifference(2);
        return l > 40L ? 0.0f : this.dragGesture.getSpeedPixelsPerMillisecond(2, 1);
    }

    protected float getDegrees(int n, int n2) {
        int n3 = n2 == 0 ? this.viewer.getScreenWidth() : this.viewer.getScreenHeight();
        return (float)n / (float)n3 * 180.0f * this.mouseDragFactor;
    }
}

