/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.common.messages.events;

import com.sparshui.common.Event;
import com.sparshui.common.utils.Converter;

public class DragEvent
implements Event {
    private static final long serialVersionUID = -2305607021385835330L;
    private float _dx;
    private float _dy;
    private byte _nPoints = 1;
    private long _time;

    public DragEvent() {
        this._dx = 0.0f;
        this._dy = 0.0f;
    }

    public DragEvent(float f, float f2, int n, long l) {
        this._dx = f;
        this._dy = f2;
        this._nPoints = (byte)n;
        this._time = l;
    }

    public DragEvent(byte[] byArray) {
        if (byArray.length < 17) {
            System.err.println("Error constructing Drag Event.");
            this._dx = 0.0f;
            this._dy = 0.0f;
        } else {
            this._dx = Converter.byteArrayToFloat(byArray, 0);
            this._dy = Converter.byteArrayToFloat(byArray, 4);
            this._nPoints = byArray[8];
            this._time = Converter.byteArrayToLong(byArray, 9);
        }
    }

    public long getTime() {
        return this._time;
    }

    public int getNPoints() {
        return this._nPoints;
    }

    public float getDx() {
        return this._dx;
    }

    public float getDy() {
        return this._dy;
    }

    public void setDx(float f) {
        this._dx = f;
    }

    public void setDy(float f) {
        this._dy = f;
    }

    public int getEventType() {
        return 0;
    }

    public String toString() {
        String string = "Drag Event: dx = " + this._dx + ", dy = " + this._dy;
        return string;
    }

    public byte[] serialize() {
        byte[] byArray = new byte[21];
        Converter.intToByteArray(byArray, 0, this.getEventType());
        Converter.floatToByteArray(byArray, 4, this._dx);
        Converter.floatToByteArray(byArray, 8, this._dy);
        byArray[12] = this._nPoints;
        Converter.longToByteArray(byArray, 13, this._time);
        return byArray;
    }
}

