/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javax.vecmath.Point3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.PolygonFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

class ObjReader
extends PolygonFileReader {
    private int nPolygons;
    String pmeshError;
    Point3f pt = new Point3f();

    ObjReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.jvxlFileHeaderBuffer.append("pmesh file format\nvertices and triangles only\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    void getSurfaceData() throws Exception {
        if (this.readPmesh()) {
            Logger.info((String)("obj file contains " + this.nVertices + " vertices and " + this.nPolygons + " polygons for " + this.nTriangles + " triangles"));
        } else {
            Logger.error((String)(this.params.fileName + ": " + (this.pmeshError == null ? "Error reading obj data " : this.pmeshError)));
        }
    }

    private boolean readPmesh() {
        block3: {
            try {
                if (this.readVertices() && this.readPolygons()) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (this.pmeshError != null) break block3;
                this.pmeshError = "pmesh ERROR: " + exception;
            }
        }
        return false;
    }

    private boolean readVertices() throws Exception {
        this.pmeshError = "pmesh ERROR: invalid vertex list";
        Point3f point3f = new Point3f();
        while (this.readLine() != null) {
            if (this.line.length() == 0 || this.nVertices == 0 && this.line.indexOf("v ") != 0) continue;
            if (this.line.indexOf("v ") != 0) break;
            this.next[0] = 2;
            point3f.set(Parser.parseFloat((String)this.line, (int[])this.next), Parser.parseFloat((String)this.line, (int[])this.next), Parser.parseFloat((String)this.line, (int[])this.next));
            if (this.isAnisotropic) {
                this.setVertexAnisotropy(point3f);
            }
            this.addVertexCopy(point3f, 0.0f, ++this.nVertices);
        }
        this.pmeshError = null;
        return true;
    }

    private boolean readPolygons() {
        block12: {
            this.nPolygons = 0;
            int n = 0;
            try {
                int n2;
                if (!this.params.readAllData) {
                    for (n2 = 0; n2 < this.params.fileIndex; ++n2) {
                        while (this.line != null && this.line.indexOf("g ") != 0) {
                            this.readLine();
                        }
                        if (this.line == null) break;
                        n = Graphics3D.getArgbFromString((String)("[x" + this.line.substring(3) + "]"));
                        this.readLine();
                    }
                }
                while (this.line != null) {
                    if (this.line.indexOf("f ") == 0) {
                        int n3;
                        ++this.nPolygons;
                        this.next[0] = 2;
                        n2 = Parser.parseInt((String)this.line, (int[])this.next);
                        int n4 = Parser.parseInt((String)this.line, (int[])this.next);
                        int n5 = Parser.parseInt((String)this.line, (int[])this.next);
                        int n6 = Parser.parseInt((String)this.line, (int[])this.next);
                        int n7 = n3 = n6 == Integer.MIN_VALUE ? 3 : 4;
                        if (n3 == 4) {
                            this.nTriangles += 2;
                            this.addTriangleCheck(n2 - 1, n4 - 1, n5 - 1, 5, 0, false, n);
                            this.addTriangleCheck(n4 - 1, n5 - 1, n6 - 1, 3, 0, false, n);
                        } else {
                            ++this.nTriangles;
                            this.addTriangleCheck(n2 - 1, n4 - 1, n5 - 1, 7, 0, false, n);
                        }
                    } else if (this.line.indexOf("g ") == 0) {
                        if (!this.params.readAllData) break;
                        n = Graphics3D.getArgbFromString((String)("[x" + this.line.substring(3) + "]"));
                    }
                    this.readLine();
                }
            }
            catch (Exception exception) {
                if (this.line == null) break block12;
                this.pmeshError = "problem reading OBJ file at: " + this.line;
            }
        }
        return true;
    }
}

