/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import org.jmol.jvxl.readers.MapFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.BinaryDocument;
import org.jmol.util.Logger;

class MrcBinaryReader
extends MapFileReader {
    protected String[] labels;
    private static byte[] b8 = new byte[8];

    MrcBinaryReader(SurfaceGenerator surfaceGenerator, String string, String string2) {
        super(surfaceGenerator, null);
        this.binarydoc = new BinaryDocument();
        if (string2 == null) {
            this.binarydoc.setStream(surfaceGenerator.getAtomDataServer().getBufferedInputStream(string), true);
        } else {
            this.binarydoc.setStream(new DataInputStream(new ByteArrayInputStream(string2.getBytes())));
        }
        this.nSurfaces = 1;
        if (this.params.thePlane == null) {
            this.params.insideOut = !this.params.insideOut;
        }
        this.allowSigma = true;
    }

    protected void readParameters() throws Exception {
        int n;
        byte[] byArray = new byte[100];
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[4];
        this.nx = this.binarydoc.readInt();
        this.ny = this.binarydoc.readInt();
        this.nz = this.binarydoc.readInt();
        this.mode = this.binarydoc.readInt();
        if (this.mode < 0 || this.mode > 6) {
            this.binarydoc.setIsBigEndian(false);
            this.nx = BinaryDocument.swapBytes((int)this.nx);
            this.ny = BinaryDocument.swapBytes((int)this.ny);
            this.nz = BinaryDocument.swapBytes((int)this.nz);
            this.mode = BinaryDocument.swapBytes((int)this.mode);
        }
        Logger.info((String)("MRC header: mode: " + this.mode));
        this.nxyzStart[0] = this.binarydoc.readInt();
        this.nxyzStart[1] = this.binarydoc.readInt();
        this.nxyzStart[2] = this.binarydoc.readInt();
        this.na = this.binarydoc.readInt();
        this.nb = this.binarydoc.readInt();
        this.nc = this.binarydoc.readInt();
        if (this.na == 0) {
            this.na = this.nx - 1;
        }
        if (this.nb == 0) {
            this.nb = this.ny - 1;
        }
        if (this.nc == 0) {
            this.nc = this.nz - 1;
        }
        this.a = this.binarydoc.readFloat();
        this.b = this.binarydoc.readFloat();
        this.c = this.binarydoc.readFloat();
        this.alpha = this.binarydoc.readFloat();
        this.beta = this.binarydoc.readFloat();
        this.gamma = this.binarydoc.readFloat();
        this.mapc = this.binarydoc.readInt();
        this.mapr = this.binarydoc.readInt();
        this.maps = this.binarydoc.readInt();
        if (this.mapc != 1 && this.params.thePlane == null) {
            this.params.dataXYReversed = true;
        }
        this.dmin = this.binarydoc.readFloat();
        this.dmax = this.binarydoc.readFloat();
        this.dmean = this.binarydoc.readFloat();
        Logger.info((String)("MRC header: dmin,dmax,dmean: " + this.dmin + "," + this.dmax + "," + this.dmean));
        int n2 = this.binarydoc.readInt();
        int n3 = this.binarydoc.readInt();
        Logger.info((String)("MRC header: ispg,nsymbt: " + n2 + "," + n3));
        this.binarydoc.readByteArray(byArray);
        this.origin.x = this.binarydoc.readFloat();
        this.origin.y = this.binarydoc.readFloat();
        this.origin.z = this.binarydoc.readFloat();
        this.binarydoc.readByteArray(byArray2);
        this.binarydoc.readByteArray(byArray3);
        float f = this.binarydoc.readFloat();
        Logger.info((String)("MRC header: rms: " + f));
        int n4 = this.binarydoc.readInt();
        Logger.info((String)("MRC header: labels: " + n4));
        this.labels = new String[n4];
        this.labels[0] = "Jmol MrcBinaryReader";
        for (n = 0; n < 10; ++n) {
            String string = this.binarydoc.readString(80).trim();
            if (n >= n4) continue;
            this.labels[n] = string;
            Logger.info((String)this.labels[n]);
        }
        for (n = 0; n < n3; ++n) {
            long l = this.binarydoc.getPosition();
            String string = this.binarydoc.readString(80).trim();
            if (string.indexOf(0) != string.lastIndexOf(0)) {
                Logger.error((String)("File indicates " + n3 + " symmetry lines, but " + n + " found!"));
                this.binarydoc.seek(l);
                break;
            }
            Logger.info((String)("MRC file symmetry information: " + string));
        }
        Logger.info((String)("MRC header: bytes read: " + this.binarydoc.getPosition() + "\n"));
        this.getVectorsAndOrigin();
        if (this.params.thePlane == null && (this.params.cutoffAutomatic || !Float.isNaN(this.params.sigma))) {
            float f2 = Float.isNaN(this.params.sigma) ? 1.0f : this.params.sigma;
            this.params.cutoff = f * f2 + this.dmean;
            Logger.info((String)("Cutoff set to (mean + rmsDeviation*" + f2 + ")\n"));
        }
        this.jvxlFileHeaderBuffer = new StringBuffer();
        this.jvxlFileHeaderBuffer.append("MRC DATA ").append(this.labels[0]).append("\n");
        this.jvxlFileHeaderBuffer.append("see http://ami.scripps.edu/software/mrctools/mrc_specification.php\n");
    }

    protected float nextVoxel() throws Exception {
        float f;
        switch (this.mode) {
            case 0: {
                f = this.binarydoc.readByte();
                break;
            }
            case 1: {
                f = this.binarydoc.readShort();
                break;
            }
            default: {
                f = this.binarydoc.readFloat();
                break;
            }
            case 3: {
                f = this.binarydoc.readShort();
                this.binarydoc.readShort();
                break;
            }
            case 4: {
                f = this.binarydoc.readFloat();
                this.binarydoc.readFloat();
                break;
            }
            case 6: {
                f = this.binarydoc.readUnsignedShort();
            }
        }
        this.nBytes = this.binarydoc.getPosition();
        return f;
    }

    protected void skipData(int n) throws Exception {
        block5: for (int i = 0; i < n; ++i) {
            switch (this.mode) {
                case 0: {
                    this.binarydoc.readByte();
                    continue block5;
                }
                case 1: 
                case 6: {
                    this.binarydoc.readByteArray(b8, 0, 2);
                    continue block5;
                }
                default: {
                    this.binarydoc.readByteArray(b8, 0, 4);
                    continue block5;
                }
                case 4: {
                    this.binarydoc.readByteArray(b8);
                }
            }
        }
    }
}

