/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.data;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.util.XmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvxlCoder {
    public static final String JVXL_VERSION1 = "2.0";
    public static final String JVXL_VERSION_XML = "2.2";
    public static final int CONTOUR_NPOLYGONS = 0;
    public static final int CONTOUR_BITSET = 1;
    public static final int CONTOUR_VALUE = 2;
    public static final int CONTOUR_COLIX = 3;
    public static final int CONTOUR_COLOR = 4;
    public static final int CONTOUR_FDATA = 5;
    public static final int CONTOUR_POINTS = 6;
    public static final int defaultEdgeFractionBase = 35;
    public static final int defaultEdgeFractionRange = 90;
    public static final int defaultColorFractionBase = 35;
    public static final int defaultColorFractionRange = 90;

    public static String jvxlGetFile(VolumeData volumeData, JvxlData jvxlData, String[] stringArray) {
        int[] nArray = volumeData.getVoxelCounts();
        jvxlData.nPointsX = nArray[0];
        jvxlData.nPointsY = nArray[1];
        jvxlData.nPointsZ = nArray[2];
        jvxlData.jvxlVolumeDataXml = volumeData.setVolumetricXml();
        return JvxlCoder.jvxlGetFile(jvxlData, null, stringArray, null, true, 1, null, null);
    }

    public static String jvxlGetFile(JvxlData jvxlData, MeshData meshData, String[] stringArray, String string, boolean bl, int n, String string2, String string3) {
        return JvxlCoder.jvxlGetFileXml(jvxlData, meshData, stringArray, string, bl, n, string2, string3);
    }

    private static String jvxlGetFileXml(JvxlData jvxlData, MeshData meshData, String[] stringArray, String string, boolean bl, int n, String string2, String string3) {
        String[] stringArray2;
        int n2;
        String string4;
        CharSequence charSequence;
        StringBuffer stringBuffer = new StringBuffer();
        if ("TRAILERONLY".equals(string)) {
            XmlUtil.closeTag((StringBuffer)stringBuffer, (String)"jvxlSurfaceSet");
            XmlUtil.closeTag((StringBuffer)stringBuffer, (String)"jvxl");
            return stringBuffer.toString();
        }
        boolean bl2 = meshData != null;
        boolean bl3 = "HEADERONLY".equals(string);
        if (bl) {
            XmlUtil.openDocument((StringBuffer)stringBuffer);
            XmlUtil.openTag((StringBuffer)stringBuffer, (String)"jvxl", (Object[])new String[]{"version", JVXL_VERSION_XML, "jmolVersion", jvxlData.version});
            if (jvxlData.jvxlFileTitle != null) {
                XmlUtil.appendCdata((StringBuffer)stringBuffer, (String)"jvxlFileTitle", null, (String)("\n" + jvxlData.jvxlFileTitle));
            }
            if (jvxlData.moleculeXml != null) {
                stringBuffer.append(jvxlData.moleculeXml);
            }
            CharSequence charSequence2 = charSequence = bl2 ? null : jvxlData.jvxlVolumeDataXml;
            if (charSequence == null) {
                charSequence = new VolumeData().setVolumetricXml();
            }
            stringBuffer.append((String)charSequence);
            XmlUtil.openTag((StringBuffer)stringBuffer, (String)"jvxlSurfaceSet", (Object[])new String[]{"count", "" + (n > 0 ? n : 1)});
            if (bl3) {
                return stringBuffer.toString();
            }
        }
        String string5 = bl2 ? "pmesh" : (string4 = jvxlData.jvxlPlane == null ? "isosurface" : "plane");
        if (jvxlData.jvxlColorData != null && jvxlData.jvxlColorData.length() > 0) {
            string4 = "mapped " + string4;
        }
        XmlUtil.openTag((StringBuffer)stringBuffer, (String)"jvxlSurface", (Object[])new String[]{"type", string4});
        stringBuffer.append(JvxlCoder.jvxlGetInfo(jvxlData, bl2));
        JvxlCoder.jvxlAppendCommandState(stringBuffer, string3, string2);
        if (stringArray != null || string != null && string.length() > 0) {
            charSequence = new StringBuffer();
            if (string != null && string.length() > 0) {
                ((StringBuffer)charSequence).append(string).append("\n");
            }
            if (stringArray != null) {
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    ((StringBuffer)charSequence).append(stringArray[n2]).append('\n');
                }
            }
            XmlUtil.appendCdata((StringBuffer)stringBuffer, (String)"jvxlSurfaceTitle", null, (String)((StringBuffer)charSequence).toString());
        }
        charSequence = new StringBuffer();
        if (jvxlData.jvxlPlane == null) {
            stringArray2 = null;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "plane";
            stringArray2 = stringArray3;
            stringArray3[1] = Escape.escape((Point4f)jvxlData.jvxlPlane);
        }
        XmlUtil.openTag((StringBuffer)charSequence, (String)"jvxlSurfaceData", stringArray2);
        if (bl2) {
            JvxlCoder.jvxlAppendMeshXml((StringBuffer)charSequence, jvxlData, meshData, true);
        } else if (jvxlData.jvxlPlane == null) {
            JvxlCoder.appendXmlEdgeData((StringBuffer)charSequence, jvxlData);
            JvxlCoder.appendXmlColorData((StringBuffer)charSequence, "jvxlColorData", jvxlData.jvxlColorData, jvxlData.isJvxlPrecisionColor, jvxlData.valueMappedToRed, jvxlData.valueMappedToBlue);
        } else {
            JvxlCoder.appendXmlColorData((StringBuffer)charSequence, "jvxlColorData", jvxlData.jvxlColorData, jvxlData.isJvxlPrecisionColor, jvxlData.valueMappedToRed, jvxlData.valueMappedToBlue);
        }
        if (jvxlData.excludedVertexCount > 0) {
            JvxlCoder.appendEncodedBitSetTag((StringBuffer)charSequence, "jvxlExcludedVertexData", jvxlData.jvxlExcluded[0], jvxlData.excludedVertexCount);
            JvxlCoder.appendEncodedBitSetTag((StringBuffer)charSequence, "jvxlExcludedPlaneData", jvxlData.jvxlExcluded[2], -1);
        }
        JvxlCoder.appendEncodedBitSetTag((StringBuffer)charSequence, "jvxlExcludedTriangleData", jvxlData.jvxlExcluded[3], jvxlData.excludedTriangleCount);
        XmlUtil.closeTag((StringBuffer)charSequence, (String)"jvxlSurfaceData");
        n2 = ((StringBuffer)charSequence).length();
        stringBuffer.append((StringBuffer)charSequence);
        if (jvxlData.vContours != null && jvxlData.vContours.length > 0) {
            JvxlCoder.jvxlEncodeContourData(jvxlData.vContours, stringBuffer);
        }
        XmlUtil.closeTag((StringBuffer)stringBuffer, (String)"jvxlSurface");
        if (bl) {
            XmlUtil.closeTag((StringBuffer)stringBuffer, (String)"jvxlSurfaceSet");
            XmlUtil.closeTag((StringBuffer)stringBuffer, (String)"jvxl");
        }
        return JvxlCoder.jvxlSetCompressionRatio(stringBuffer, jvxlData, n2);
    }

    private static void appendEncodedBitSetTag(StringBuffer stringBuffer, String string, BitSet bitSet, int n) {
        if (n < 0) {
            n = BitSetUtil.cardinalityOf((BitSet)bitSet);
        }
        if (n == 0) {
            return;
        }
        StringBuffer stringBuffer2 = new StringBuffer("\n ");
        JvxlCoder.jvxlEncodeBitSet(bitSet, -1, stringBuffer2);
        XmlUtil.appendTag((StringBuffer)stringBuffer, (String)string, (Object[])new String[]{"bsEncoding", "base90+35", "count", "" + n, "len", "" + bitSet.length()}, (Object)JvxlCoder.jvxlCompressString(stringBuffer2.toString(), true));
    }

    private static String jvxlSetCompressionRatio(StringBuffer stringBuffer, JvxlData jvxlData, int n) {
        String string = stringBuffer.toString();
        int n2 = (int)(jvxlData.nBytes > 0L ? (float)jvxlData.nBytes / (float)n : (float)(jvxlData.nPointsX * jvxlData.nPointsY * jvxlData.nPointsZ * 13) / (float)n);
        return TextFormat.simpleReplace((String)string, (String)"#RATIO#", (String)(n2 > 0 ? "" + n2 : "?"));
    }

    private static void appendXmlEdgeData(StringBuffer stringBuffer, JvxlData jvxlData) {
        XmlUtil.appendTag((StringBuffer)stringBuffer, (String)"jvxlEdgeData", (Object[])new String[]{"count", "" + (jvxlData.jvxlEdgeData.length() - 1), "encoding", "base90f1", "bsEncoding", "base90+35c", "isXLowToHigh", "" + jvxlData.isXLowToHigh, "data", JvxlCoder.jvxlCompressString(jvxlData.jvxlEdgeData, true)}, (Object)("\n" + JvxlCoder.jvxlCompressString(jvxlData.jvxlSurfaceData, true)));
    }

    private static void jvxlAppendCommandState(StringBuffer stringBuffer, String string, String string2) {
        if (string != null) {
            XmlUtil.appendCdata((StringBuffer)stringBuffer, (String)"jvxlIsosurfaceCommand", null, (String)("\n" + (string.indexOf("#") < 0 ? string : string.substring(0, string.indexOf("#"))) + "\n"));
        }
        if (string2 != null) {
            if (string2.indexOf("** XML ** ") >= 0) {
                string2 = TextFormat.split((String)string2, (String)"** XML **")[1].trim();
                XmlUtil.appendTag((StringBuffer)stringBuffer, (String)"jvxlIsosurfaceState", (Object)("\n" + string2 + "\n"));
            } else {
                XmlUtil.appendCdata((StringBuffer)stringBuffer, (String)"jvxlIsosurfaceState", null, (String)("\n" + string2 + "\n"));
            }
        }
    }

    private static void appendXmlColorData(StringBuffer stringBuffer, String string, String string2, boolean bl, float f, float f2) {
        int n;
        if (string2 == null || (n = string2.length() - 1) < 0) {
            return;
        }
        if (bl) {
            n /= 2;
        }
        XmlUtil.appendTag((StringBuffer)stringBuffer, (String)string, (Object[])new String[]{"count", "" + n, "encoding", "base90f" + (bl ? "2" : "1"), "min", "" + f, "max", "" + f2, "data", JvxlCoder.jvxlCompressString(string2, true)}, null);
    }

    public static String jvxlGetInfo(JvxlData jvxlData) {
        return JvxlCoder.jvxlGetInfo(jvxlData, jvxlData.vertexDataOnly);
    }

    public static String jvxlGetInfo(JvxlData jvxlData, boolean bl) {
        float f;
        int n;
        if (jvxlData.jvxlSurfaceData == null) {
            return "";
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n2 = jvxlData.nSurfaceInts;
        int n3 = bl ? 0 : jvxlData.jvxlEdgeData.length() - 1;
        int n4 = n = jvxlData.jvxlColorData == null ? -1 : jvxlData.jvxlColorData.length() - 1;
        if (!bl) {
            JvxlCoder.addAttrib(arrayList, "\n  cutoff", "" + jvxlData.cutoff);
            JvxlCoder.addAttrib(arrayList, "\n  isCutoffAbsolute", "" + jvxlData.isCutoffAbsolute);
            JvxlCoder.addAttrib(arrayList, "\n  pointsPerAngstrom", "" + jvxlData.pointsPerAngstrom);
            int n5 = jvxlData.jvxlSurfaceData.length() + n3 + n + 1;
            if (n5 > 0) {
                JvxlCoder.addAttrib(arrayList, "\n  nBytesData", "" + n5);
            }
            JvxlCoder.addAttrib(arrayList, "\n  isXLowToHigh", "" + jvxlData.isXLowToHigh);
            if (jvxlData.jvxlPlane == null) {
                JvxlCoder.addAttrib(arrayList, "\n  nSurfaceInts", "" + n2);
                JvxlCoder.addAttrib(arrayList, "\n  nBytesUncompressedEdgeData", "" + n3);
            }
            if (n > 0) {
                JvxlCoder.addAttrib(arrayList, "\n  nBytesUncompressedColorData", "" + n);
            }
        }
        if (jvxlData.isJvxlPrecisionColor) {
            JvxlCoder.addAttrib(arrayList, "\n  precisionColor", "true");
        }
        if (jvxlData.colorDensity) {
            JvxlCoder.addAttrib(arrayList, "\n  colorDensity", "true");
        }
        if (jvxlData.jvxlPlane == null) {
            if (jvxlData.isContoured) {
                JvxlCoder.addAttrib(arrayList, "\n  contoured", "true");
                JvxlCoder.addAttrib(arrayList, "\n  colorMapped", "true");
            } else if (jvxlData.isBicolorMap) {
                JvxlCoder.addAttrib(arrayList, "\n  bicolorMap", "true");
            } else if (n > 0) {
                JvxlCoder.addAttrib(arrayList, "\n  colorMapped", "true");
            }
            if (jvxlData.vContours != null && jvxlData.vContours.length > 0) {
                JvxlCoder.addAttrib(arrayList, "\n  nContourData", "" + jvxlData.vContours.length);
            }
        } else {
            if (jvxlData.scale3d != 0.0f) {
                JvxlCoder.addAttrib(arrayList, "\n  scale3d", "" + jvxlData.scale3d);
            }
            if (n > 0) {
                JvxlCoder.addAttrib(arrayList, "\n  colorMapped", "true");
            }
            JvxlCoder.addAttrib(arrayList, "\n  plane", Escape.escape((Point4f)jvxlData.jvxlPlane));
        }
        jvxlData.excludedVertexCount = BitSetUtil.cardinalityOf((BitSet)jvxlData.jvxlExcluded[0]);
        jvxlData.excludedTriangleCount = BitSetUtil.cardinalityOf((BitSet)jvxlData.jvxlExcluded[3]);
        if (jvxlData.excludedVertexCount > 0) {
            JvxlCoder.addAttrib(arrayList, "\n  nExcludedVertexes", "" + jvxlData.excludedVertexCount);
        }
        if (jvxlData.excludedTriangleCount > 0) {
            JvxlCoder.addAttrib(arrayList, "\n  nExcludedTriangles", "" + jvxlData.excludedTriangleCount);
        }
        if (jvxlData.isContoured) {
            if (jvxlData.contourValues == null || jvxlData.contourColixes == null) {
                if (jvxlData.vContours == null) {
                    JvxlCoder.addAttrib(arrayList, "\n  nContours", "" + Math.abs(jvxlData.nContours));
                }
            } else {
                if (jvxlData.jvxlPlane != null) {
                    JvxlCoder.addAttrib(arrayList, "\n  contoured", "true");
                }
                JvxlCoder.addAttrib(arrayList, "\n  nContours", "" + jvxlData.contourValues.length);
                JvxlCoder.addAttrib(arrayList, "\n  contourValues", Escape.escapeArray((Object)(jvxlData.contourValuesUsed == null ? jvxlData.contourValues : jvxlData.contourValuesUsed)));
                JvxlCoder.addAttrib(arrayList, "\n  contourColors", jvxlData.contourColors);
            }
        }
        float f2 = jvxlData.mappedDataMin == Float.MAX_VALUE ? 0.0f : jvxlData.mappedDataMin;
        float f3 = jvxlData.isColorReversed ? jvxlData.valueMappedToRed : jvxlData.valueMappedToBlue;
        float f4 = f = jvxlData.isColorReversed ? jvxlData.valueMappedToBlue : jvxlData.valueMappedToRed;
        if (jvxlData.jvxlColorData != null && jvxlData.jvxlColorData.length() > 0 && !jvxlData.isBicolorMap) {
            JvxlCoder.addAttrib(arrayList, "\n  dataMinimum", "" + f2);
            JvxlCoder.addAttrib(arrayList, "\n  dataMaximum", "" + jvxlData.mappedDataMax);
            JvxlCoder.addAttrib(arrayList, "\n  valueMappedToRed", "" + f);
            JvxlCoder.addAttrib(arrayList, "\n  valueMappedToBlue", "" + f3);
        }
        if (jvxlData.insideOut) {
            JvxlCoder.addAttrib(arrayList, "\n  insideOut", "true");
        }
        if (jvxlData.isXLowToHigh) {
            JvxlCoder.addAttrib(arrayList, "\n  note", "progressive JVXL+ -- X values read from low(0) to high(" + (jvxlData.nPointsX - 1) + ")");
        }
        JvxlCoder.addAttrib(arrayList, "\n  xyzMin", Escape.escape((Tuple3f)jvxlData.boundingBox[0]));
        JvxlCoder.addAttrib(arrayList, "\n  xyzMax", Escape.escape((Tuple3f)jvxlData.boundingBox[1]));
        JvxlCoder.addAttrib(arrayList, "\n  approximateCompressionRatio", "#RATIO#:1");
        JvxlCoder.addAttrib(arrayList, "\n  jmolVersion", jvxlData.version);
        StringBuffer stringBuffer = new StringBuffer();
        XmlUtil.openTag((StringBuffer)stringBuffer, (String)"jvxlSurfaceInfo", (Object[])arrayList.toArray());
        XmlUtil.closeTag((StringBuffer)stringBuffer, (String)"jvxlSurfaceInfo");
        return stringBuffer.toString();
    }

    private static void addAttrib(List<String[]> list, String string, String string2) {
        list.add(new String[]{string, string2});
    }

    private static void jvxlEncodeContourData(List<Object>[] listArray, StringBuffer stringBuffer) {
        XmlUtil.openTag((StringBuffer)stringBuffer, (String)"jvxlContourData", (Object[])new String[]{"count", "" + listArray.length});
        for (int i = 0; i < listArray.length; ++i) {
            if (listArray[i].size() < 6) continue;
            int n = (Integer)listArray[i].get(0);
            StringBuffer stringBuffer2 = new StringBuffer("\n");
            BitSet bitSet = (BitSet)listArray[i].get(1);
            JvxlCoder.jvxlEncodeBitSet(bitSet, n, stringBuffer2);
            XmlUtil.appendTag((StringBuffer)stringBuffer, (String)"jvxlContour", (Object[])new String[]{"index", "" + i, "value", "" + listArray[i].get(2), "color", Escape.escapeColor((int)((int[])listArray[i].get(4))[0]), "count", "" + bitSet.length(), "encoding", "base90iff1", "bsEncoding", "base90+35c", "data", JvxlCoder.jvxlCompressString(listArray[i].get(5).toString(), true)}, (Object)JvxlCoder.jvxlCompressString(stringBuffer2.toString(), true));
        }
        XmlUtil.closeTag((StringBuffer)stringBuffer, (String)"jvxlContourData");
    }

    public static void set3dContourVector(List<Object> list, int[][] nArray, Point3f[] point3fArray) {
        if (list.size() < 6) {
            return;
        }
        StringBuffer stringBuffer = (StringBuffer)list.get(5);
        BitSet bitSet = (BitSet)list.get(1);
        int n = 0;
        int n2 = stringBuffer.length();
        int n3 = 0;
        int n4 = 32;
        int n5 = 32;
        int n6 = bitSet.nextSetBit(0);
        while (n6 >= 0) {
            int n7;
            int n8;
            int n9;
            int n10;
            int[] nArray2 = nArray[n6];
            while (n < n2) {
                char c = stringBuffer.charAt(n++);
                n4 = c;
                if (!Character.isDigit(c)) continue;
            }
            n3 = n4 - 48;
            while (n < n2) {
                char c = stringBuffer.charAt(n++);
                n4 = c;
                if (Character.isWhitespace(c)) continue;
            }
            while (n < n2) {
                char c = stringBuffer.charAt(n++);
                n5 = c;
                if (Character.isWhitespace(c)) continue;
            }
            float f = JvxlCoder.jvxlFractionFromCharacter(n4, 35, 90, 0.0f);
            float f2 = JvxlCoder.jvxlFractionFromCharacter(n5, 35, 90, 0.0f);
            if ((n3 & 1) == 0) {
                n10 = nArray2[1];
                n8 = n9 = nArray2[2];
                n7 = nArray2[0];
            } else {
                n10 = nArray2[0];
                n8 = nArray2[1];
                if ((n3 & 2) != 0) {
                    n9 = n8;
                    n7 = nArray2[2];
                } else {
                    n9 = nArray2[2];
                    n7 = n10;
                }
            }
            list.add(JvxlCoder.getContourPoint(point3fArray, n10, n8, f));
            list.add(JvxlCoder.getContourPoint(point3fArray, n9, n7, f2));
            n6 = bitSet.nextSetBit(n6 + 1);
        }
    }

    private static Point3f getContourPoint(Point3f[] point3fArray, int n, int n2, float f) {
        Point3f point3f = new Point3f();
        point3f.set((Tuple3f)point3fArray[n2]);
        point3f.sub((Tuple3f)point3fArray[n]);
        point3f.scale(f);
        point3f.add((Tuple3f)point3fArray[n]);
        return point3f;
    }

    public static void appendContourTriangleIntersection(int n, float f, float f2, StringBuffer stringBuffer) {
        stringBuffer.append(n);
        stringBuffer.append(JvxlCoder.jvxlFractionAsCharacter(f));
        stringBuffer.append(JvxlCoder.jvxlFractionAsCharacter(f2));
    }

    public static void jvxlCreateColorData(JvxlData jvxlData, float[] fArray) {
        int n;
        if (fArray == null) {
            jvxlData.jvxlColorData = "";
            return;
        }
        boolean bl = jvxlData.isJvxlPrecisionColor;
        boolean bl2 = jvxlData.isTruncated;
        int n2 = jvxlData.colorFractionBase;
        int n3 = jvxlData.colorFractionRange;
        float f = jvxlData.valueMappedToBlue;
        float f2 = jvxlData.valueMappedToRed;
        int n4 = n = jvxlData.saveVertexCount > 0 ? jvxlData.saveVertexCount : jvxlData.vertexCount;
        if (n >= fArray.length) {
            System.out.println("JVXLCODER ERROR");
        }
        float f3 = jvxlData.mappedDataMin;
        float f4 = jvxlData.mappedDataMax;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            float f5 = fArray[i];
            if (bl2) {
                float f6 = f5 = f5 > 0.0f ? 0.999f : -0.999f;
            }
            if (bl) {
                JvxlCoder.jvxlAppendCharacter2(f5, f3, f4, n2, n3, stringBuffer, stringBuffer2);
                continue;
            }
            stringBuffer.append(JvxlCoder.jvxlValueAsCharacter(f5, f2, f, n2, n3));
        }
        jvxlData.jvxlColorData = stringBuffer.append(stringBuffer2).append('\n').toString();
    }

    private static void jvxlAppendMeshXml(StringBuffer stringBuffer, JvxlData jvxlData, MeshData meshData, boolean bl) {
        int[] nArray = new int[meshData.vertexCount];
        if (JvxlCoder.appendXmlTriangleData(stringBuffer, meshData.polygonIndexes, meshData.polygonCount, nArray, bl)) {
            JvxlCoder.appendXmlVertexData(stringBuffer, jvxlData, nArray, meshData.vertices, meshData.vertexValues, meshData.vertexCount, meshData.polygonColorData, meshData.polygonCount, jvxlData.jvxlColorData.length() > 0, bl);
        }
    }

    private static boolean appendXmlTriangleData(StringBuffer stringBuffer, int[][] nArray, int n, int[] nArray2, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            if (nArray[n6] == null) {
                ++n6;
                continue;
            }
            int n7 = nArray[n6][n3];
            n7 = nArray2[n7] > 0 ? nArray2[n7] : (nArray2[n7] = ++n4);
            int n8 = n7 - n2;
            n2 = n7;
            if (n8 == 0) {
                stringBuffer2.append('!');
                bl2 = false;
            } else if (n8 > 32) {
                if (bl2) {
                    stringBuffer2.append('+');
                }
                stringBuffer2.append(n8);
                bl2 = true;
            } else if (n8 < -32) {
                stringBuffer2.append(n8);
                bl2 = true;
            } else {
                stringBuffer2.append((char)(92 + n8));
                bl2 = false;
            }
            if (++n3 % 3 != 0) continue;
            n3 = 0;
            ++n6;
            ++n5;
        }
        if (stringBuffer2.length() == 0) {
            return false;
        }
        XmlUtil.appendTag((StringBuffer)stringBuffer, (String)"jvxlTriangleData", (Object[])new String[]{"count", "" + n5, "encoding", "jvxltdiff", "data", JvxlCoder.jvxlCompressString(stringBuffer2.toString(), bl)}, null);
        return true;
    }

    private static void appendXmlVertexData(StringBuffer stringBuffer, JvxlData jvxlData, int[] nArray, Point3f[] point3fArray, float[] fArray, int n, String string, int n2, boolean bl, boolean bl2) {
        int n3;
        int n4 = jvxlData.colorFractionBase;
        int n5 = jvxlData.colorFractionRange;
        Point3f point3f = jvxlData.boundingBox[0];
        Point3f point3f2 = jvxlData.boundingBox[1];
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int[] nArray2 = new int[n];
        for (n3 = 0; n3 < n; ++n3) {
            if (nArray[n3] <= 0) continue;
            nArray2[nArray[n3] - 1] = n3;
        }
        for (n3 = 0; n3 < n; ++n3) {
            Point3f point3f3 = point3fArray[nArray2[n3]];
            JvxlCoder.jvxlAppendCharacter2(point3f3.x, point3f.x, point3f2.x, n4, n5, stringBuffer2, stringBuffer3);
            JvxlCoder.jvxlAppendCharacter2(point3f3.y, point3f.y, point3f2.y, n4, n5, stringBuffer2, stringBuffer3);
            JvxlCoder.jvxlAppendCharacter2(point3f3.z, point3f.z, point3f2.z, n4, n5, stringBuffer2, stringBuffer3);
        }
        stringBuffer2.append(stringBuffer3);
        XmlUtil.appendTag((StringBuffer)stringBuffer, (String)"jvxlVertexData", (Object[])new String[]{"count", "" + n, "min", Escape.escape((Tuple3f)point3f), "max", Escape.escape((Tuple3f)point3f2), "encoding", "base90xyz2", "data", JvxlCoder.jvxlCompressString(stringBuffer2.toString(), bl2)}, null);
        if (string != null) {
            XmlUtil.appendTag((StringBuffer)stringBuffer, (String)"jvxlPolygonColorData", (Object[])new String[]{"encoding", "jvxlnc", "count", "" + n2}, (Object)("\n" + string));
        }
        if (!bl) {
            return;
        }
        stringBuffer2 = new StringBuffer();
        stringBuffer3 = new StringBuffer();
        for (n3 = 0; n3 < n; ++n3) {
            float f = fArray[nArray2[n3]];
            JvxlCoder.jvxlAppendCharacter2(f, jvxlData.mappedDataMin, jvxlData.mappedDataMax, n4, n5, stringBuffer2, stringBuffer3);
        }
        JvxlCoder.appendXmlColorData(stringBuffer, "jvxlColorData", stringBuffer2.append(stringBuffer3).append("\n").toString(), true, jvxlData.valueMappedToRed, jvxlData.valueMappedToBlue);
    }

    public static char jvxlFractionAsCharacter(float f) {
        return JvxlCoder.jvxlFractionAsCharacter(f, 35, 90);
    }

    public static char jvxlFractionAsCharacter(float f, int n, int n2) {
        if (f > 0.9999f) {
            f = 0.9999f;
        } else if (Float.isNaN(f)) {
            f = 1.0001f;
        }
        int n3 = (int)(f * (float)n2 + (float)n);
        if (n3 < n) {
            return (char)n;
        }
        if (n3 == 92) {
            return '!';
        }
        return (char)n3;
    }

    private static void jvxlAppendCharacter2(float f, float f2, float f3, int n, int n2, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        float f4 = f2 == f3 ? f : (f - f2) / (f3 - f2);
        char c = JvxlCoder.jvxlFractionAsCharacter(f4, n, n2);
        stringBuffer.append(c);
        stringBuffer2.append(JvxlCoder.jvxlFractionAsCharacter((f4 -= JvxlCoder.jvxlFractionFromCharacter(c, n, n2, 0.0f)) * (float)n2, n, n2));
    }

    public static float jvxlFractionFromCharacter(int n, int n2, int n3, float f) {
        float f2;
        if (n == n2 + n3) {
            return Float.NaN;
        }
        if (n < n2) {
            n = 92;
        }
        if ((f2 = ((float)(n - n2) + f) / (float)n3) < 0.0f) {
            return 0.0f;
        }
        if (f2 > 1.0f) {
            return 0.999999f;
        }
        return f2;
    }

    public static float jvxlFractionFromCharacter2(int n, int n2, int n3, int n4) {
        float f = JvxlCoder.jvxlFractionFromCharacter(n, n3, n4, 0.0f);
        float f2 = JvxlCoder.jvxlFractionFromCharacter(n2, n3, n4, 0.5f);
        return f + f2 / (float)n4;
    }

    public static char jvxlValueAsCharacter(float f, float f2, float f3, int n, int n2) {
        float f4 = f2 == f3 ? f : (f - f2) / (f3 - f2);
        return JvxlCoder.jvxlFractionAsCharacter(f4, n, n2);
    }

    protected static float jvxlValueFromCharacter2(int n, int n2, float f, float f2, int n3, int n4) {
        float f3 = JvxlCoder.jvxlFractionFromCharacter2(n, n2, n3, n4);
        return f2 == f ? f3 : f + f3 * (f2 - f);
    }

    public static int jvxlEncodeBitSet0(BitSet bitSet, int n, StringBuffer stringBuffer) {
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        if (n < 0) {
            n = bitSet.length();
        }
        int n5 = 0;
        boolean bl = false;
        int n6 = n - 1;
        for (int i = 0; i < n; ++i) {
            if (bl == bitSet.get(i)) {
                ++n2;
                continue;
            }
            if (n2 == n3 && i != n6) {
                ++n4;
            } else {
                if (n4 > 0) {
                    stringBuffer.append(' ').append(-n4);
                    n4 = 0;
                    ++n5;
                }
                stringBuffer.append(' ').append(n2);
                ++n5;
                n3 = n2;
            }
            n2 = 1;
            bl = !bl;
        }
        stringBuffer.append(' ').append(n2).append('\n');
        return n5;
    }

    public static int jvxlEncodeBitSet(BitSet bitSet, int n, StringBuffer stringBuffer) {
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        if (n < 0) {
            n = bitSet.length();
        }
        if (n == 0) {
            return 0;
        }
        stringBuffer.append("-");
        for (int i = 0; i < n; ++i) {
            if (bl == bitSet.get(i)) {
                ++n2;
                continue;
            }
            JvxlCoder.jvxlAppendEncodedNumber(stringBuffer, n2, 35, 90);
            ++n3;
            n2 = 1;
            bl = !bl;
        }
        JvxlCoder.jvxlAppendEncodedNumber(stringBuffer, n2, 35, 90);
        stringBuffer.append('\n');
        return n3;
    }

    public static void jvxlAppendEncodedNumber(StringBuffer stringBuffer, int n, int n2, int n3) {
        boolean bl;
        boolean bl2 = bl = n < n3;
        if (n == 0) {
            stringBuffer.append((char)n2);
        } else if (!bl) {
            stringBuffer.append((char)(n2 + n3));
        }
        while (n > 0) {
            int n4 = n / n3;
            int n5 = n2 + n - n4 * n3;
            if (n5 == 92) {
                n5 = 33;
            }
            stringBuffer.append((char)n5);
            n = n4;
        }
        if (!bl) {
            stringBuffer.append(" ");
        }
    }

    public static BitSet jvxlDecodeBitSet(String string, int n, int n2) {
        BitSet bitSet = new BitSet();
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int[] nArray = new int[1];
        while ((n3 = JvxlCoder.jvxlParseEncodedInt(string, n, n2, nArray)) != Integer.MIN_VALUE) {
            if (bl) {
                bitSet.set(n4, n4 + n3);
            }
            n4 += n3;
            bl = !bl;
        }
        return bitSet;
    }

    public static int jvxlParseEncodedInt(String string, int n, int n2, int[] nArray) {
        boolean bl;
        int n3;
        boolean bl2 = false;
        int n4 = 0;
        int n5 = string.length();
        if (n3 < 0) {
            return Integer.MIN_VALUE;
        }
        for (n3 = nArray[0]; n3 < n5 && Character.isWhitespace(string.charAt(n3)); ++n3) {
        }
        if (n3 >= n5) {
            return Integer.MIN_VALUE;
        }
        int n6 = 1;
        boolean bl3 = bl = string.charAt(n3) == n + n2;
        if (bl) {
            ++n3;
        }
        while (n3 < n5 && !Character.isWhitespace(string.charAt(n3))) {
            int n7 = string.charAt(n3);
            if (n7 < n) {
                n7 = 92;
            }
            n4 += (n7 - n) * n6;
            bl2 = true;
            ++n3;
            if (!bl) break;
            n6 *= n2;
        }
        if (!bl2) {
            n4 = Integer.MIN_VALUE;
        }
        nArray[0] = n3;
        return n4;
    }

    public static BitSet jvxlDecodeBitSet(String string) {
        if (string.startsWith("-")) {
            return JvxlCoder.jvxlDecodeBitSet(JvxlCoder.jvxlUncompressString(string.substring(1)), 35, 90);
        }
        BitSet bitSet = new BitSet();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int[] nArray = new int[1];
        while (true) {
            int n5 = n = n3++ < 0 ? n : Parser.parseInt((String)string, (int[])nArray);
            if (n == Integer.MIN_VALUE) break;
            if (n < 0) {
                n3 = n;
                n = n2;
                continue;
            }
            if (bl) {
                bitSet.set(n4, n4 + n);
            }
            n4 += n;
            n2 = n;
            bl = !bl;
        }
        return bitSet;
    }

    public static String jvxlCompressString(String string, boolean bl) {
        if (string.indexOf("~") >= 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        int n2 = string.length();
        block4: for (int i = 0; i <= n2; ++i) {
            char c2 = i == n2 ? (char)'\u0000' : string.charAt(i);
            switch (c2) {
                case '\n': 
                case '\r': {
                    continue block4;
                }
                case '&': 
                case '<': {
                    bl2 = bl;
                    break;
                }
                default: {
                    bl2 = false;
                }
            }
            if (c2 == c) {
                ++n;
                c2 = '\u0000';
            } else if (n > 0 || bl3) {
                if (n < 4 && !bl3 || c == ' ' || c == '\t') {
                    while (--n >= 0) {
                        stringBuffer.append(c);
                    }
                } else {
                    if (bl3) {
                        bl3 = false;
                    } else {
                        stringBuffer.append('~');
                    }
                    stringBuffer.append(n);
                    stringBuffer.append(' ');
                }
                n = 0;
            }
            if (c2 == '\u0000') continue;
            if (bl2) {
                bl3 = true;
                bl2 = false;
                stringBuffer.append('~');
                c = c2;
                c2 = (char)(c2 - '\u0001');
            } else {
                c = c2;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String jvxlUncompressString(String string) {
        if (string.indexOf("~") < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        int[] nArray = new int[1];
        block5: for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == '~') {
                nArray[0] = ++i;
                c2 = string.charAt(i);
                switch (c2) {
                    case '%': 
                    case ';': {
                        nArray[0] = nArray[0] + 1;
                        c = c2 = (char)(c2 + '\u0001');
                        stringBuffer.append(c);
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        int n = Parser.parseInt((String)string, (int[])nArray);
                        for (int j = 0; j < n; ++j) {
                            stringBuffer.append(c);
                        }
                        i = nArray[0];
                        continue block5;
                    }
                    case '~': {
                        --i;
                        break;
                    }
                    default: {
                        Logger.error((String)("Error uncompressing string " + string.substring(0, i) + "?"));
                    }
                }
            }
            stringBuffer.append(c2);
            c = c2;
        }
        return stringBuffer.toString();
    }

    public static void jvxlCreateHeaderWithoutTitleOrAtoms(VolumeData volumeData, StringBuffer stringBuffer) {
        JvxlCoder.jvxlCreateHeader(volumeData, Integer.MAX_VALUE, null, null, stringBuffer);
    }

    public static void jvxlCreateHeader(VolumeData volumeData, int n, Point3f[] point3fArray, int[] nArray, StringBuffer stringBuffer) {
        int n2;
        volumeData.setVolumetricXml();
        if (stringBuffer.length() == 0) {
            stringBuffer.append("Line 1\nLine 2\n");
        }
        stringBuffer.append(n == Integer.MIN_VALUE ? "+2" : (n == Integer.MAX_VALUE ? "-2" : "" + -n)).append(' ').append(volumeData.volumetricOrigin.x).append(' ').append(volumeData.volumetricOrigin.y).append(' ').append(volumeData.volumetricOrigin.z).append(" ANGSTROMS\n");
        for (n2 = 0; n2 < 3; ++n2) {
            stringBuffer.append(volumeData.voxelCounts[n2]).append(' ').append(volumeData.volumetricVectors[n2].x).append(' ').append(volumeData.volumetricVectors[n2].y).append(' ').append(volumeData.volumetricVectors[n2].z).append('\n');
        }
        if (n != Integer.MAX_VALUE && n != Integer.MIN_VALUE) {
            n = Math.abs(n);
            int n3 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                n3 = Math.abs(nArray[n2]);
                stringBuffer.append(n3 + " " + n3 + ".0 " + point3fArray[n2].x + " " + point3fArray[n2].y + " " + point3fArray[n2].z + "\n");
            }
            return;
        }
        Point3f point3f = new Point3f(volumeData.volumetricOrigin);
        stringBuffer.append("1 1.0 ").append(point3f.x).append(' ').append(point3f.y).append(' ').append(point3f.z).append(" //BOGUS H ATOM ADDED FOR JVXL FORMAT\n");
        for (int i = 0; i < 3; ++i) {
            point3f.scaleAdd((float)(volumeData.voxelCounts[i] - 1), (Tuple3f)volumeData.volumetricVectors[i], (Tuple3f)point3f);
        }
        stringBuffer.append("2 2.0 ").append(point3f.x).append(' ').append(point3f.y).append(' ').append(point3f.z).append(" //BOGUS He ATOM ADDED FOR JVXL FORMAT\n");
    }
}

