/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Point3i;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Text;
import org.jmol.shape.TextShape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Escape;

public class Hover
extends TextShape {
    private static final String FONTFACE = "SansSerif";
    private static final String FONTSTYLE = "Plain";
    private static final int FONTSIZE = 12;
    Text hoverText;
    int atomIndex = -1;
    Point3i xy;
    String text;
    String labelFormat = "%U";
    String[] atomFormats;
    String specialLabel;

    public void initShape() {
        super.initShape();
        this.isHover = true;
        Font3D font3D = this.g3d.getFont3D(FONTFACE, FONTSTYLE, 12.0f);
        short s = Graphics3D.getColix("#FFFFC3");
        short s2 = 4;
        this.hoverText = new Text(this.g3d, font3D, null, s2, s, 0, 0, 1, Integer.MIN_VALUE, 1, 0.0f);
        this.currentObject = this.hoverText;
        this.hoverText.setAdjustForWindow(true);
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if ("target" == string) {
            this.atomIndex = object == null ? -1 : (Integer)object;
            return;
        }
        if ("text" == string) {
            this.text = (String)object;
            if (this.text != null && this.text.length() == 0) {
                this.text = null;
            }
            return;
        }
        if ("specialLabel" == string) {
            this.specialLabel = (String)object;
            return;
        }
        if ("atomLabel" == string) {
            String string2 = (String)object;
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            int n = this.viewer.getAtomCount();
            if (this.atomFormats == null || this.atomFormats.length < n) {
                this.atomFormats = new String[n];
            }
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                this.atomFormats[n2] = string2;
                n2 = bitSet.nextSetBit(n2 + 1);
            }
            return;
        }
        if ("xy" == string) {
            this.xy = (Point3i)object;
            return;
        }
        if ("label" == string) {
            this.labelFormat = (String)object;
            if (this.labelFormat != null && this.labelFormat.length() == 0) {
                this.labelFormat = null;
            }
            return;
        }
        if (string == "deleteModelAtoms") {
            if (this.atomFormats != null) {
                int n = ((int[])((Object[])object)[2])[1];
                int n3 = ((int[])((Object[])object)[2])[2];
                this.atomFormats = (String[])ArrayUtil.deleteElements(this.atomFormats, n, n3);
            }
            this.atomIndex = -1;
            return;
        }
        super.setProperty(string, object, null);
    }

    public String getShapeState() {
        Hashtable<String, BitSet> hashtable = new Hashtable<String, BitSet>();
        if (this.atomFormats != null) {
            int n = this.viewer.getAtomCount();
            while (--n >= 0) {
                if (this.atomFormats[n] == null) continue;
                Hover.setStateInfo(hashtable, n, "set hoverLabel " + Escape.escape(this.atomFormats[n]));
            }
        }
        return "\n  hover " + Escape.escape(this.labelFormat == null ? "" : this.labelFormat) + ";\n" + Hover.getShapeCommands(hashtable, null);
    }
}

