/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptFunction;
import org.jmol.util.Logger;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelProcessor
extends ScriptFunction {
    Viewer viewer;
    volatile int counter = 0;
    volatile Error error = null;
    Object lock = new Object();
    List<Process> processes = new ArrayList<Process>();

    ParallelProcessor(String string, int n) {
        super(string, n);
    }

    public static Object getExecutor() {
        return Executors.newCachedThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAllProcesses(Viewer viewer, boolean bl) {
        if (this.processes.size() == 0) {
            return;
        }
        this.viewer = viewer;
        bl &= !viewer.isParallel() && viewer.setParallel(true);
        ArrayList<ShapeManager> arrayList = new ArrayList<ShapeManager>();
        this.error = null;
        this.counter = 0;
        if (Logger.debugging) {
            Logger.debug("running " + this.processes.size() + " processes on " + Viewer.nProcessors + " processesors inParallel=" + bl);
        }
        this.counter = this.processes.size();
        int n = this.processes.size();
        while (--n >= 0) {
            ShapeManager shapeManager = null;
            if (bl) {
                shapeManager = new ShapeManager(viewer, viewer.getModelSet());
                arrayList.add(shapeManager);
            }
            this.runProcess(this.processes.remove(0), shapeManager);
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.counter > 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.error == null) continue;
                throw this.error;
            }
        }
        this.mergeResults(arrayList);
        viewer.setParallel(false);
    }

    void mergeResults(List<ShapeManager> list) {
        try {
            for (int i = 0; i < list.size(); ++i) {
                this.viewer.mergeShapes(list.get(i).getShapes());
            }
        }
        catch (Error error) {
            throw error;
        }
        finally {
            this.counter = -1;
            list = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearShapeManager(Error error) {
        ParallelProcessor parallelProcessor = this;
        synchronized (parallelProcessor) {
            this.error = error;
            this.notifyAll();
        }
    }

    void addProcess(String string, ScriptContext scriptContext) {
        this.processes.add(new Process(string, scriptContext));
    }

    private void runProcess(Process process, ShapeManager shapeManager) {
        Executor executor;
        RunProcess runProcess = new RunProcess(process, this.lock, shapeManager);
        Executor executor2 = executor = shapeManager == null ? null : (Executor)this.viewer.getExecutor();
        if (executor != null) {
            executor.execute(runProcess);
        } else {
            runProcess.run();
        }
    }

    class RunProcess
    implements Runnable {
        private Process process;
        private Object processLock;
        private ShapeManager shapeManager;

        public RunProcess(Process process, Object object, ShapeManager shapeManager) {
            this.process = process;
            this.processLock = object;
            this.shapeManager = shapeManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (ParallelProcessor.this.error == null) {
                    if (Logger.debugging) {
                        Logger.debug("Running process " + this.process.processName + " " + this.process.context.pc + " - " + (this.process.context.pcEnd - 1));
                    }
                    ParallelProcessor.this.viewer.eval(this.process.context, this.shapeManager);
                    if (Logger.debugging) {
                        Logger.debug("Process " + this.process.processName + " complete");
                    }
                }
            }
            catch (Exception exception) {
                if (ParallelProcessor.this.tok != 364558) {
                    exception.printStackTrace();
                }
            }
            catch (Error error) {
                ParallelProcessor.this.clearShapeManager(error);
            }
            finally {
                Object object = this.processLock;
                synchronized (object) {
                    --ParallelProcessor.this.counter;
                    this.processLock.notifyAll();
                }
            }
        }
    }

    static class Process {
        String processName;
        ScriptContext context;

        Process(String string, ScriptContext scriptContext) {
            this.processName = string;
            this.context = scriptContext;
        }
    }
}

