/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export.image;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImageEncoder
implements ImageConsumer {
    protected OutputStream out;
    private ImageProducer producer;
    private int width = -1;
    private int height = -1;
    private int hintflags = 0;
    private boolean started = false;
    private boolean encoding;
    private IOException iox;
    private static final ColorModel rgbModel = ColorModel.getRGBdefault();
    private boolean accumulate = false;
    private int[] accumulator;

    public ImageEncoder(Image image, OutputStream outputStream) {
        this(image.getSource(), outputStream);
    }

    public ImageEncoder(ImageProducer imageProducer, OutputStream outputStream) {
        this.producer = imageProducer;
        this.out = outputStream;
    }

    abstract void encodeStart(int var1, int var2) throws IOException;

    abstract void encodePixels(int var1, int var2, int var3, int var4, int[] var5, int var6, int var7) throws IOException;

    abstract void encodeDone() throws IOException;

    public synchronized void encode() throws IOException {
        this.encoding = true;
        this.iox = null;
        this.producer.startProduction(this);
        while (this.encoding) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.iox != null) {
            throw this.iox;
        }
    }

    private void encodePixelsWrapper(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws IOException {
        if (!this.started) {
            this.started = true;
            this.encodeStart(this.width, this.height);
            if ((this.hintflags & 2) == 0) {
                this.accumulate = true;
                this.accumulator = new int[this.width * this.height];
            }
        }
        if (this.accumulate) {
            for (int i = 0; i < n4; ++i) {
                System.arraycopy(nArray, i * n6 + n5, this.accumulator, (n2 + i) * this.width + n, n3);
            }
        } else {
            this.encodePixels(n, n2, n3, n4, nArray, n5, n6);
        }
    }

    private void encodeFinish() throws IOException {
        if (this.accumulate) {
            this.encodePixels(0, 0, this.width, this.height, this.accumulator, 0, this.width);
            this.accumulator = null;
            this.accumulate = false;
        }
    }

    private synchronized void stop() {
        this.encoding = false;
        this.notifyAll();
    }

    @Override
    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    @Override
    public void setProperties(Hashtable<?, ?> hashtable) {
    }

    @Override
    public void setColorModel(ColorModel colorModel) {
    }

    @Override
    public void setHints(int n) {
        this.hintflags = n;
    }

    @Override
    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int[] nArray = new int[n3];
        for (int i = 0; i < n4; ++i) {
            int n7 = n5 + i * n6;
            for (int j = 0; j < n3; ++j) {
                nArray[j] = colorModel.getRGB(byArray[n7 + j] & 0xFF);
            }
            try {
                this.encodePixelsWrapper(n, n2 + i, n3, 1, nArray, 0, n3);
                continue;
            }
            catch (IOException iOException) {
                this.iox = iOException;
                this.stop();
                return;
            }
        }
    }

    @Override
    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (colorModel == rgbModel) {
            try {
                this.encodePixelsWrapper(n, n2, n3, n4, nArray, n5, n6);
            }
            catch (IOException iOException) {
                this.iox = iOException;
                this.stop();
                return;
            }
        } else {
            int[] nArray2 = new int[n3];
            for (int i = 0; i < n4; ++i) {
                int n7 = n5 + i * n6;
                for (int j = 0; j < n3; ++j) {
                    nArray2[j] = colorModel.getRGB(nArray[n7 + j]);
                }
                try {
                    this.encodePixelsWrapper(n, n2 + i, n3, 1, nArray2, 0, n3);
                    continue;
                }
                catch (IOException iOException) {
                    this.iox = iOException;
                    this.stop();
                    return;
                }
            }
        }
    }

    @Override
    public void imageComplete(int n) {
        this.producer.removeConsumer(this);
        if (n == 4) {
            this.iox = new IOException("image aborted");
        } else {
            try {
                this.encodeFinish();
                this.encodeDone();
            }
            catch (IOException iOException) {
                this.iox = iOException;
            }
        }
        this.stop();
    }
}

