/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Vector3f;
import org.jmol.adapter.readers.quantum.SpartanSmolReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SpartanArchive {
    private int atomCount = 0;
    private String bondData;
    private int moCount = 0;
    private int coefCount = 0;
    private int shellCount = 0;
    private int gaussianCount = 0;
    private String endCheck;
    private String calculationType = "";
    private String line;
    private AtomSetCollection atomSetCollection;
    private AtomSetCollectionReader r;
    private Map<String, Object> moData;
    private List<Map<String, Object>> orbitals = new ArrayList<Map<String, Object>>();
    private int modelAtomCount;

    private String[] getTokens() {
        return Parser.getTokens((String)this.line);
    }

    SpartanArchive(AtomSetCollectionReader atomSetCollectionReader, AtomSetCollection atomSetCollection, Map<String, Object> map) {
        this.initialize(atomSetCollectionReader, atomSetCollection, map, "");
    }

    SpartanArchive(AtomSetCollectionReader atomSetCollectionReader, AtomSetCollection atomSetCollection, Map<String, Object> map, String string, String string2) {
        this.initialize(atomSetCollectionReader, atomSetCollection, map, string);
        this.endCheck = string2;
    }

    private void initialize(AtomSetCollectionReader atomSetCollectionReader, AtomSetCollection atomSetCollection, Map<String, Object> map, String string) {
        this.r = atomSetCollectionReader;
        this.atomSetCollection = atomSetCollection;
        this.moData = map;
        map.put("isNormalized", Boolean.TRUE);
        map.put("energyUnits", "");
        this.bondData = string;
    }

    int readArchive(String string, boolean bl, int n, boolean bl2) throws Exception {
        this.modelAtomCount = this.setInfo(string);
        this.line = bl ? "GEOMETRY" : "";
        boolean bl3 = false;
        while (this.line != null) {
            if (this.line.equals("GEOMETRY")) {
                this.readAtoms(n, bl2);
                if (bl2 && this.bondData.length() > 0) {
                    this.addBonds(this.bondData, n);
                }
            } else if (this.line.indexOf("BASIS") == 0) {
                this.readBasis();
            } else if (this.line.indexOf("WAVEFUNC") == 0 || this.line.indexOf("BETA") == 0) {
                if (this.filterMO()) {
                    this.readMolecularOrbital();
                    bl3 = true;
                }
            } else if (this.line.indexOf("ENERGY") == 0) {
                this.readEnergy();
            } else if (this.line.equals("ENDARCHIVE") || this.endCheck != null && this.line.indexOf(this.endCheck) == 0) break;
            this.readLine();
        }
        if (bl3) {
            this.r.setMOData(this.moData);
        }
        return this.atomCount;
    }

    private boolean filterMO() {
        if (this.r.filter == null) {
            return true;
        }
        return this.r.filter.indexOf("nomo") < 0;
    }

    private void readEnergy() throws Exception {
        String[] stringArray = SpartanArchive.getTokens(this.readLine());
        float f = this.parseFloat(stringArray[0]);
        this.atomSetCollection.setAtomSetAuxiliaryInfo("energy", (Object)new Float(f));
        if (this.r instanceof SpartanSmolReader) {
            String string = ((SpartanSmolReader)this.r).constraints;
            this.atomSetCollection.setAtomSetName(string + (string.length() == 0 ? "" : " ") + "Energy=" + f + " KJ");
        }
        this.atomSetCollection.setAtomSetEnergy(stringArray[0], f);
    }

    private static String[] getTokens(String string) {
        return Parser.getTokens((String)string);
    }

    private int parseInt(String string) {
        return this.r.parseInt(string);
    }

    private float parseFloat(String string) {
        return this.r.parseFloat(string);
    }

    private int setInfo(String string) throws Exception {
        String[] stringArray = SpartanArchive.getTokens(string);
        if (Logger.debugging) {
            Logger.debug((String)("reading Spartan archive info :" + string));
        }
        this.modelAtomCount = this.parseInt(stringArray[0]);
        this.coefCount = this.parseInt(stringArray[1]);
        this.shellCount = this.parseInt(stringArray[2]);
        this.gaussianCount = this.parseInt(stringArray[3]);
        this.moCount = this.parseInt(stringArray[6]);
        this.calculationType = stringArray[9];
        String string2 = (String)this.moData.get("calculationType");
        if (string2 == null) {
            string2 = this.calculationType;
        } else if (string2.indexOf(this.calculationType) < 0) {
            string2 = this.calculationType + string2;
        }
        this.r.calculationType = string2;
        this.moData.put("calculationType", this.r.calculationType);
        return this.modelAtomCount;
    }

    void readAtoms(int n, boolean bl) throws Exception {
        for (int i = 0; i < this.modelAtomCount; ++i) {
            this.readLine();
            String[] stringArray = this.getTokens();
            Atom atom = bl ? this.atomSetCollection.addNewAtom() : this.atomSetCollection.getAtom(n - this.modelAtomCount + i);
            atom.elementSymbol = AtomSetCollectionReader.getElementSymbol((int)this.parseInt(stringArray[0]));
            atom.set(this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]));
            atom.scale(0.5291772f);
        }
        if (bl && Logger.debugging) {
            Logger.debug((String)(this.atomCount + " atoms read"));
        }
    }

    void addBonds(String string, int n) {
        String[] stringArray = SpartanArchive.getTokens(string);
        int n2 = this.modelAtomCount;
        while (n2 < stringArray.length) {
            int n3;
            int n4 = this.parseInt(stringArray[n2++]) - 1 + n;
            int n5 = this.parseInt(stringArray[n2++]) - 1 + n;
            if ((n3 = this.parseInt(stringArray[n2++])) <= 0) continue;
            this.atomSetCollection.addBond(new Bond(n4, n5, n3 < 4 ? n3 : (n3 == 5 ? 515 : 1)));
        }
        n2 = this.atomSetCollection.getBondCount();
        if (Logger.debugging) {
            Logger.debug((String)(n2 + " bonds read"));
        }
    }

    void readBasis() throws Exception {
        int n;
        int n2;
        Object[] objectArray;
        int n3;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        float[][] fArrayArray = new float[this.gaussianCount][];
        int[] nArray = new int[this.gaussianCount];
        for (n3 = 0; n3 < this.shellCount; ++n3) {
            this.readLine();
            String[] stringArray = this.getTokens();
            objectArray = new int[4];
            objectArray[0] = this.parseInt(stringArray[3]) - 1;
            n2 = this.parseInt(stringArray[0]);
            objectArray[1] = n2 == 0 ? 0 : n2 + 1;
            int n4 = objectArray[2] = this.parseInt(stringArray[2]) - 1;
            n = objectArray[3] = this.parseInt(stringArray[1]);
            for (int i = 0; i < n; ++i) {
                nArray[n4 + i] = n2;
            }
            arrayList.add((int[])objectArray);
        }
        for (n3 = 0; n3 < this.gaussianCount; ++n3) {
            float f = this.parseFloat(this.readLine());
            objectArray = SpartanArchive.getTokens(this.readLine());
            n2 = objectArray.length;
            float[] fArray = new float[n2 + 1];
            fArray[0] = f;
            n = nArray[n3];
            switch (n) {
                case 1: {
                    fArray[2] = this.parseFloat((String)objectArray[1]);
                }
                case 0: {
                    fArray[1] = this.parseFloat((String)objectArray[0]);
                    break;
                }
                case 2: {
                    fArray[1] = this.parseFloat((String)objectArray[2]);
                    break;
                }
                case 3: {
                    fArray[1] = this.parseFloat((String)objectArray[3]);
                }
            }
            fArrayArray[n3] = fArray;
        }
        this.moData.put("shells", arrayList);
        this.moData.put("gaussians", fArrayArray);
        if (Logger.debugging) {
            Logger.debug((String)(arrayList.size() + " slater shells read"));
            Logger.debug((String)(fArrayArray.length + " gaussian primitives read"));
        }
    }

    void readMolecularOrbital() throws Exception {
        int n;
        int n2 = 0;
        String[] stringArray = SpartanArchive.getTokens("");
        float[] fArray = new float[this.moCount];
        float[][] fArray2 = new float[this.moCount][this.coefCount];
        for (n = 0; n < this.moCount; ++n) {
            if (n2 == stringArray.length) {
                stringArray = SpartanArchive.getTokens(this.readLine());
                n2 = 0;
            }
            fArray[n] = this.parseFloat(stringArray[n2++]);
        }
        for (n = 0; n < this.moCount; ++n) {
            for (int i = 0; i < this.coefCount; ++i) {
                if (n2 == stringArray.length) {
                    stringArray = SpartanArchive.getTokens(this.readLine());
                    n2 = 0;
                }
                fArray2[n][i] = this.parseFloat(stringArray[n2++]);
            }
        }
        for (n = 0; n < this.moCount; ++n) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("energy", Float.valueOf(fArray[n]));
            hashtable.put("coefficients", fArray2[n]);
            this.orbitals.add(hashtable);
        }
        if (Logger.debugging) {
            Logger.debug((String)(this.orbitals.size() + " molecular orbitals read"));
        }
        this.moData.put("mos", this.orbitals);
    }

    void readProperties() throws Exception {
        Logger.debug((String)"Reading PROPARC properties records...");
        while (this.readLine() != null && !this.line.startsWith("ENDPROPARC") && !this.line.startsWith("END Directory Entry ")) {
            if (this.line.length() >= 4 && this.line.substring(0, 4).equals("PROP")) {
                this.readProperty();
            }
            if (this.line.length() >= 6 && this.line.substring(0, 6).equals("DIPOLE")) {
                this.readDipole();
            }
            if (this.line.length() < 7 || !this.line.substring(0, 7).equals("VIBFREQ")) continue;
            this.readVibFreqs();
        }
        this.setVibrationsFromProperties();
    }

    void readDipole() throws Exception {
        this.readLine();
        String[] stringArray = this.getTokens();
        this.setDipole(stringArray);
    }

    private void setDipole(String[] stringArray) {
        if (stringArray.length != 3) {
            return;
        }
        Vector3f vector3f = new Vector3f(this.parseFloat(stringArray[0]), this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]));
        this.atomSetCollection.setAtomSetAuxiliaryInfo("dipole", (Object)vector3f);
    }

    private void readProperty() throws Exception {
        String[] stringArray = this.getTokens();
        if (stringArray.length == 0) {
            return;
        }
        boolean bl = stringArray[1].startsWith("STRING");
        String string = stringArray[2];
        boolean bl2 = string.equals("DIPOLE_VEC");
        Object object = new Object();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (stringArray[3].equals("=")) {
            object = bl ? this.getQuotedString(stringArray[4].substring(0, 1)) : new Float(this.parseFloat(stringArray[4]));
        } else if (stringArray[stringArray.length - 1].equals("BEGIN")) {
            int n = this.parseInt(stringArray[stringArray.length - 2]);
            if (n == 0) {
                n = 1;
            }
            boolean bl3 = stringArray.length == 6;
            ArrayList<Float> arrayList2 = new ArrayList<Float>();
            int n2 = 0;
            while (this.readLine() != null && !this.line.substring(0, 3).equals("END")) {
                if (bl) {
                    object = this.getQuotedString("\"");
                    arrayList.add(object);
                    continue;
                }
                String[] stringArray2 = this.getTokens();
                if (bl2) {
                    this.setDipole(stringArray2);
                }
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    if (bl3) {
                        arrayList2.add(Float.valueOf(this.parseFloat(stringArray2[n3])));
                        if ((n2 + 1) % n == 0) {
                            arrayList.add(arrayList2);
                            arrayList2 = new ArrayList();
                        }
                    } else {
                        object = Float.valueOf(this.parseFloat(stringArray2[n3]));
                        arrayList.add(object);
                    }
                    ++n3;
                    ++n2;
                }
            }
            object = null;
        } else if (Logger.debugging) {
            Logger.debug((String)(" Skipping property line " + this.line));
        }
        if (object != null) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo(string, object);
        }
        if (arrayList.size() != 0) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo(string, arrayList);
        }
    }

    void readVibFreqs() throws Exception {
        Cloneable cloneable;
        int n;
        this.readLine();
        String string = "";
        int n2 = this.parseInt(this.line);
        ArrayList arrayList = new ArrayList();
        ArrayList<Cloneable> arrayList2 = new ArrayList<Cloneable>();
        if (Logger.debugging) {
            Logger.debug((String)("reading VIBFREQ vibration records: frequencyCount = " + n2));
        }
        boolean[] blArray = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            int n3 = this.atomSetCollection.getAtomCount();
            boolean bl = blArray[n] = !this.r.doGetVibration(n + 1);
            if (!blArray[n] && this.r.desiredVibrationNumber <= 0) {
                this.atomSetCollection.cloneLastAtomSet();
                this.addBonds(this.bondData, n3);
            }
            this.readLine();
            cloneable = new Hashtable();
            float f = this.parseFloat(this.line);
            cloneable.put("freq", new Float(f));
            if (this.line.length() > 15 && !(string = this.line.substring(15, this.line.length())).equals("???")) {
                cloneable.put("label", string);
            }
            arrayList2.add(cloneable);
            if (blArray[n]) continue;
            this.atomSetCollection.setAtomSetFrequency(null, string, "" + f, null);
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("VibFreqs", arrayList2);
        n = this.atomSetCollection.getFirstAtomSetAtomCount();
        ArrayList<Cloneable> arrayList3 = new ArrayList<Cloneable>();
        cloneable = new ArrayList();
        int n4 = 0;
        int n5 = n;
        int n6 = 3;
        float[] fArray = new float[3];
        while (this.readLine() != null) {
            String[] stringArray = this.getTokens();
            for (int i = 0; i < stringArray.length; ++i) {
                float f;
                fArray[i % n6] = f = this.parseFloat(stringArray[i]);
                cloneable.add(Float.valueOf(f));
                if ((i + 1) % n6 != 0) continue;
                if (!blArray[n4]) {
                    this.atomSetCollection.addVibrationVector(n5, fArray[0], fArray[1], fArray[2]);
                    arrayList3.add(cloneable);
                    cloneable = new ArrayList();
                }
                ++n5;
            }
            if (n5 % n != 0) continue;
            if (!blArray[n4]) {
                arrayList.add(arrayList3);
            }
            arrayList3 = new ArrayList();
            if (++n4 != n2) continue;
            break;
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("vibration", arrayList);
    }

    private void setVibrationsFromProperties() throws Exception {
        Object object;
        Float f;
        int n;
        int n2;
        List list = (List)this.atomSetCollection.getAtomSetCollectionAuxiliaryInfo("FREQ_MODES");
        if (list == null) {
            return;
        }
        List list2 = (List)this.atomSetCollection.getAtomSetCollectionAuxiliaryInfo("FREQ_LAB");
        List list3 = (List)this.atomSetCollection.getAtomSetCollectionAuxiliaryInfo("FREQ_VAL");
        int n3 = list3.size();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList();
        if (Logger.debugging) {
            Logger.debug((String)("reading PROP VALUE:VIB FREQ_MODE vibration records: frequencyCount = " + n3));
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.atomSetCollection.getAtomCount();
            this.atomSetCollection.cloneLastAtomSet();
            this.addBonds(this.bondData, n);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            f = (Float)list3.get(n2);
            hashtable.put("freq", f);
            float f2 = f.floatValue();
            object = (String)list2.get(n2);
            if (!((String)object).equals("???")) {
                hashtable.put("label", object);
            }
            arrayList2.add(hashtable);
            this.atomSetCollection.setAtomSetName((String)object + " " + f2 + " cm^-1");
            this.atomSetCollection.setAtomSetProperty("Frequency", f2 + " cm^-1");
            this.atomSetCollection.setAtomSetProperty(".PATH", "Frequencies");
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("VibFreqs", arrayList2);
        n = n2 = this.atomSetCollection.getFirstAtomSetAtomCount();
        for (int i = 0; i < n3; ++i) {
            if (!this.r.doGetVibration(i + 1)) continue;
            int n4 = 0;
            object = new ArrayList();
            List list4 = (List)list.get(i);
            int n5 = 0;
            while (n5 < n2) {
                ArrayList<Float> arrayList3 = new ArrayList<Float>();
                f = (Float)list4.get(n4++);
                float f3 = f.floatValue();
                arrayList3.add(f);
                f = (Float)list4.get(n4++);
                float f4 = f.floatValue();
                arrayList3.add(f);
                f = (Float)list4.get(n4++);
                float f5 = f.floatValue();
                arrayList3.add(f);
                this.atomSetCollection.addVibrationVector(n, f3, f4, f5);
                object.add(arrayList3);
                ++n5;
                ++n;
            }
            arrayList.add(object);
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("vibration", arrayList);
    }

    private String getQuotedString(String string) {
        int n = this.line.indexOf(string);
        int n2 = this.line.lastIndexOf(string);
        return n2 == n ? "" : this.line.substring(n + 1, n2);
    }

    private String readLine() throws Exception {
        this.line = this.r.readLine();
        return this.line;
    }
}

