//
// OpenVRML
//
// Copyright 2001  Henri Manson
// Copyright 2008  Braden McDaniel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

package vrml.field;

import vrml.Field;

/**
 * Represents a VRML SFTime field in Java.
 */
public class SFTime extends Field {

    /**
     * Construct a new SFTime field in OpenVRML using the given value.
     *
     * @param time Initial value of field.
     */
    static native long createPeer(double time);

    /**
     * Construct a default SFTime field.
     */
    public SFTime() {
        this(0.0);
    }

    /**
     * Construct from a peer handle.
     */
    SFTime(long peer) {
        super(peer);
    }

    /**
     * Construct an SFTime field using the given value.
     *
     * @param time Initial value of field.
     */
    public SFTime(double time) {
        super(createPeer(time));
    }

    /**
     * Get the value of the SFTime field.
     *
     * @return Value of SFTime.
     */
    public native double getValue();

    /**
     * Set the value of an SFTime field.
     *
     * @param time Value to set SFTime field to.
     */
    public native void setValue(double time);

    /**
     * Set the value of an SFTime field.
     *
     * @param time Value to set SFTime field to.
     */
    public void setValue(ConstSFTime time) {
        this.setValue(time.getValue());
    }

    /**
     * Set the value of an SFTime field.
     *
     * @param time Value to set SFTime field to.
     */
    public void setValue(SFTime time) {
        this.setValue(time.getValue());
    }
}
