###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_wow_raid_manager_xss_vuln.nasl 1040 2009-02-27 16:05:33Z feb $
#
# WoW Raid Manager Cross-Site Scripting Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900515);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6161");
  script_bugtraq_id(31661);
  script_name(english:"WoW Raid Manager Cross-Site Scripting Vulnerability");
  desc["english"] = "

  Overview: The host is installed with WoW Raid Manager and is prone to
  Cross-Site Scripting vulnerability.

  Vulnerability Insight:
  The flaw exists due to WoW Raid Manager fails to properly sanitise user
  supplied input.

  Impact: Successful remote exploitation will let the attacker execute
  arbitrary code in the scope of the application. As a result the attacker
  may gain sensitive information and use it to redirect the user to any
  other malicious URL.

  Impact Level: Application

  Affected Software/OS:
  WoW Raid Manager versions prior to 3.5.1.

  Fix: Upgrade to version 3.5.1
  http://www.wowraidmanager.net/downloadrel.php

  References:
  http://secunia.com/advisories/32172
  http://sourceforge.net/project/shownotes.php?release_id=631789

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.2
  Risk factor : Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of WoW Raid Manager");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"General");
  script_dependencies("secpod_wow_raid_manager_detect.nasl");
  script_require_ports("Services/www", 80);
  script_require_keys("WoWRaidManager/Ver");
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

wowPort = get_http_port(default:80);
if(!wowPort){
  exit(0);
}

wowVer = get_kb_item("WoWRaidManager/Ver");
if(!wowVer){
  exit(0);
}

if(version_is_less(version:wowVer, test_version:"3.5.1")){
  security_warning(wowPort);
}
