###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_proftpd_server_detect.nasl 1025 2009-02-19 09:44:19Z feb $
#
# ProFTPD Server Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900506);
  script_version("Revision: 1.0 ");
  script_name(english:"ProFTPD Server Version Detection");
  desc["english"] = "
  Overview : This script detects the installed version of ProFTP Server and
  saves the version in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set KB for the Version of ProFTPD Server");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod ");
  script_family(english:"FTP");
  script_dependencies("find_service.nes");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");
include("version_func.inc");

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  ftpPort = 21;
}

if(!get_port_state(ftpPort)){
  exit(0);
}

# Get the version from banner
banner = get_ftp_banner(port:ftpPort);
if(banner != NULL)
{
  if("ProFTPD" >< banner)
  {
    ftpVer = eregmatch(pattern:"ProFTPD ([0-9.]+)(rc[0-9])?", string:banner);
    if(ftpVer[1] != NULL)
    {
      if(ftpVer[2] != NULL)
      {
        ftpVer = ftpVer[1] + "." + ftpVer[2];
        set_kb_item(name:"ProFTPD/Ver", value:ftpVer);
        exit(0);
      }
      set_kb_item(name:"ProFTPD/Ver", value:ftpVer[1]);
      exit(0);
    }
  }
}

# Get the version from file
sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

ftpPaths = find_file(file_name:"proftpd", file_path:"/", useregex:TRUE,
                     regexpar:"$", sock:sock);

foreach binPath (ftpPaths)
{
  binPath = chomp(binary_proName);

  ftpVer = get_bin_version(full_prog_name:binPath, version_argv:"-v",
                          ver_pattern:"ProFTPD Version ([0-9.a-z]+)", sock:sock);
  ftpVer = eregmatch(pattern:"Version ([0-9.]+)(rc[0-9])?", string:ftpVer[0]);

  if(ftpVer[1] != NULL)
  {
    if(ftpVer[2] != NULL)
    {
      ftpVer = ftpVer[1] + "." + ftpVer[2];
      set_kb_item(name:"ProFTPD/Ver", value:ftpVer);
      ssh_close_connection();
      exit(0);
    }
    set_kb_item(name:"ProFTPD/Ver", value:ftpVer[1]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
