#############################################################################
#
#  Pidgin NSS plugin SSL Certificate Validation Security Bypass Vulnerability (Linux)
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/06
#
#  Revision: 1.3 
#
#  Log: schandan
#  Issue #0089
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900022);
 script_bugtraq_id(30553);
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.3 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Misc.");
 script_name(english:"Pidgin NSS plugin SSL Certificate Validation Security Bypass Vulnerability (Linux)");
 script_summary(english:"Check for vulnerable version of Pidgin");
 desc["english"] = "
 Overview : The host is running Pidgin, which is prone to Security Bypass
 Vulnerability
 
 Vulnerability Insight:
 
        The application fails to properly validate SSL (Secure Sockets Layer) 
        certificate from a server.

        Impact : Man-in-the-middle attacks or identity impersonation attacks are possible. 

 Impact Level : Network.

 Affected Software/OS:
        Pidgin Version 2.4.3 and prior on Linux.

 Fix : Apply the patch,
 http://developer.pidgin.im/attachment/ticket/6500/nss-cert-verify.patc h

 References : http://developer.pidgin.im/ticket/6500

 CVSS Score :
        CVSS Base Score     : 7.8 (AV:N/AC:M/Au:NR/C:C/I:P/A:N)
        CVSS Temporal Score : 6.1
 Risk factor : High";

 script_description(english:desc["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/uname");
 exit(0);
}


 include("ssh_func.inc");

 if("Linux" >!< get_kb_item("ssh/login/uname")){
        exit(0);
 }

 foreach item (get_kb_list("ssh/*/rpms"))
 {
	if("pidgin~" >< item)
	{
		if(egrep(pattern:"^pidgin~([01]\..*|2\.([0-3](\..*)?|" +
				 "4(\.[0-3])?))($|[^.0-9])", string:item))
		{
                	security_warning(0);
			exit(0);
		}
 	}
 }

 sock = ssh_login_or_reuse_connection();
 if(!sock){
	exit(0);
 }

 pidginVer = ssh_cmd(socket:sock, cmd:"pidgin --version", timeout:timeout);
 ssh_close_connection();

 if(!pidginVer){
	exit(0);
 }

 if(egrep(pattern:"Pidgin ([01]\..*|2\.([0-3](\..*)?|4(\.[0-3])?))($|[^.0-9])",
	  string:pidginVer)){
 	security_warning(0);
 }
