###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_openoffice_detect_win.nasl 893 2009-01-29 10:15:46Z jan $
#
# OpenOffice Version Detection (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(900072);
  script_version("$Revision: 1.0 $");
  script_name(english:"OpenOffice Version Detection (Win)");
  desc["english"] = "

  Overview: The script detects the version of OpenOffice and sets the
  result in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set the KB for the version of OpenOffice");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\OpenOffice.org")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
keys = registry_enum_keys(key);

foreach item (keys)
{
  if("OpenOffice.org" >< registry_get_sz(key:key + item, item:"DisplayName"))
  {
    openVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(openVer){
      set_kb_item(name:"OpenOffice/Win/Ver", value:openVer);
    }
    exit(0);
  }
}
