###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-007.nasl 0891 2009-03-11 09:09:37Z mar $
#
# Vulnerability in SChannel Could Allow Spoofing (960225)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900087);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0085");
  script_bugtraq_id(34015);
  script_name(english:"Vulnerability in SChannel Could Allow Spoofing (960225)");
  desc["english"] = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-007.

  Vulnerability Insight:
  Spoofing flaw exists in the Microsoft Windows SChannel (Secure Channel)
  authentication component when using certificate based authentication.

  Impact:
  Attacker who successfully exploited would be able to authenticate to a
  server using only an authorized user's digital certificate and without
  the associated private key.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2K Service Pack 4 and prior.
  Microsoft Windows XP Service Pack 3 and prior.
  Microsoft Windows 2003 Service Pack 2 and prior.

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-007.mspx

  References:
  http://www.microsoft.com/technet/security/bulletin/ms09-007.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the vulnerable File Version");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

# Check for Hotfix 960225 (MS09-007)
if(hotfix_missing(name:"960225") == 0){
  exit(0);
}

sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!sysPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:sysPath + "\Schannel.dll");

sysVer = GetVer(file:file, share:share);
if(!sysVer){
  exit(0);
}

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  # Grep for Schannel.dll version < 5.1.2195.7213
  if(version_is_less(version:sysVer, test_version:"5.1.2195.7213")){
    security_hole(0);
  }
  exit(0);
}

# Windows XP
if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Schannel.dll < 5.1.2600.3487
    if(version_is_less(version:sysVer, test_version:"5.1.2600.3487")){
       security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep for Schannel.dll < 5.1.2600.5721
    if(version_is_less(version:sysVer, test_version:"5.1.2600.5721")){
       security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}

# Windows 2003
if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 1" >< SP)
  {
    # Grep for Schannel.dll version < 5.2.3790.3293
    if(version_is_less(version:sysVer, test_version:"5.2.3790.3293")){
       security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 2" >< SP)
  {
    # Grep for Schannel.dll version < 5.2.3790.4458
    if(version_is_less(version:sysVer, test_version:"5.2.3790.4458")){
       security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
