# OpenVAS Vulnerability Test
# $Id$
# Description: 
# MDNS, Bonjour, zeroconf Service detection and Information Gathering
#
# MDNS_detect.nasl
#
#TODO: it's also possible to retrieve the architecture: ppc, i386, ...
#
# Author:
# Christian Eric Edjenguele <christian.edjenguele@owasp.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2+,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

 

 
if(description)
{

script_id(101013);

name["english"] = "Ensure the presence of the MDNS Service";
script_name(english:name["english"]);
 
desc["english"] = "
The Remote Host is Running the MDNS Service.  
Zeroconf, or Zero Configuration Networking, often kwon as MDNS or Bonjour/rendez-vous, 
is a set of techniques that automatically create a usable IP network without configuration or special servers.




Solution :
It's recommanded to disable this service if not use.


Risk factor : None";


script_description(english:desc["english"]);
 
summary["english"] = "Detects the presence of the MDNS service";
script_summary(english:summary["english"]);
 
script_category(ACT_GATHER_INFO);
 
script_copyright(english:"This script is Written by Christian Eric Edjenguele <christian.edjenguele@owasp.org> and released under GPL v2 or later");
family["english"] = "Service detection";
script_family(english:family["english"]);
script_require_ports("Services/udp/mdns", 5353);

exit(0);
}


#
# The script code starts here
#

include("misc_func.inc");


#
# Functions for mdns protocol manipulation
#


function grabHostInfos(stringa) 
{

	length = ord(stringa[51]) * 256 + ord(stringa[52]) - 1;

	straddr = substr(stringa , 54, 51 + length);
	pad = split(straddr, sep:"[");

	addr = str_replace(string:pad[1], find:"]", replace:""); 

	na = str_replace(string:pad[0], find:"0xe20x800x99", replace:"");
	nb = str_replace(string:na, find:"\ ", replace:"-");
	n  = str_replace(string:nb, find:"\'", replace:"");
	limits = max_index(n) - 1;

	name = n[limits]; 

	# save the mac address and hostname
	infos = make_array(0, addr, 1, name);

	return (infos); 

}


function grabCpuInfos(stringa)
{

	offset = 13 + ord(stringa[12]) + 23;

	# determine the limits to extract cpu type
	cpu_len = ord(stringa[offset]);
	mn = offset + 1;
	mj = mn + cpu_len;
	cpu_type = substr(stringa , mn , mj);

	# determine the limits to extract operating system type
	offset += cpu_len + 1;
	minor = offset + 1;
	major = minor + ord(stringa[offset]);

	pados = substr(stringa , minor , major );
	os = split(pados, sep:";");
	os_x = os[0];

	# save cpu type and operating system 
	infos = make_array(0, cpu_type, 1, os_x);

	return (infos); 
}


function RunMDNSQuery(query, itype)
{
	if(strlen(query) != 3) return;

	pkt2 = "";
	pkt1 = "0x000x4a0x010x000x000x010x000x000x000x000x000x00";

	foreach element (query)
	{
		length = strlen(element); 
		pkt1 += raw_string(length) + element;
	}
    
	if(itype == 'PTR') 
		pkt1 += "0x000x000x0c0x000x01";
    
	if(itype == 'HINFO')
	{
		foreach element (query)
		{
			pkt1 = pkt1 + "0x000x0d0x000x010x00";
			return (pkt1);
		}
	}

	return (pkt1);

}

#
# NVT starts here
#

# define some local variables
port = get_kb_item("Services/udp/mdns");
version = "";

qry1 = make_list('_daap', '_tcp', 'local');
qry2 = make_list('_workstation', '_tcp', 'local');

# forge the MDNS Host Infos negociation protocol
pkt1 = RunMDNSQuery(query:qry1, itype:'PTR');
pkt2 = RunMDNSQuery(query:qry2, itype:'PTR');

if(!get_port_state(port))
	exit(0);
else
{
	soc = open_sock_udp(port);
	if(soc)
	{
		send(socket:soc, data:pkt1);
		send(socket:soc, data:pkt2);

		reply = recv(socket:soc, length:1024);

		if(reply) 

			# get host informations
			hostinfos = grabHostInfos(stringa:reply);

		qry3 = make_list(hostinfos[1], 'local', '');

		# forge the MDNS CPU Infos negociation protocol
		pkt3 = RunMDNSQuery(query:qry3, itype:'HINFO');

		send(socket:soc, data:pkt3);
		reply = recv(socket:soc, length:4096);
		
		# get cpu informations
		cpuinfos = grabCpuInfos(stringa:reply);
		
		close(soc);

	}

	# save gathered informations into variables
	mac_address = hostinfos[0];
	hostname = hostinfos[1];
	cpu_type = cpuinfos[0];
	operating_system = cpuinfos[1];

	# build report string
	report  = 'Hostname: ' + hostname;
	report += ' \nMAC Address: ' + mac_address;
	report += '\nCPU Type: ' + cpu_type;
	report += '\nOperating System: ' + operating_system;

	# Save informations into the kb
	set_kb_item (name:"MDNS/Host/hostname", value:hostname);
	set_kb_item (name:"MDNS/Host/OS", value:operating_system);
	set_kb_item (name:"MDNS/Host/MacAddress", value:mac_address);
	set_kb_item (name:"MDNS/Host/CpuType", value:cpu_type);
	 
	register_service(port:port, ipproto:"udp", proto:"mdns");

	# report MDNS service running
	security_note(port:port, data:report); 
}

