#
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
                                                                                
if(description)
{
 script_id(63613);
 script_cve_id("CVE-2008-2374");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200903-29 (bluez-utils bluez-libs)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200903-29.

Insufficient input validation in BlueZ may lead to arbitrary code execution
or a Denial of Service.

Solution:
All bluez-utils users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=net-wireless/bluez-utils-3.36'

All bluez-libs users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=net-wireless/bluez-libs-3.36'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200903-29
http://bugs.gentoo.org/show_bug.cgi?id=230591

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200903-29 (bluez-utils bluez-libs)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"net-wireless/bluez-utils", unaffected: make_list("ge 3.36"), vulnerable: make_list("lt 3.36"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"net-wireless/bluez-libs", unaffected: make_list("ge 3.36"), vulnerable: make_list("lt 3.36"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
