# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(61041);
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200805-07 (ltsp)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200805-07.

Multiple vulnerabilities have been discovered in components shipped with
LTSP which allow remote attackers to compromise terminal clients.

Solution:
LTSP 4.2 is not maintained upstream in favor of version 5. Since version 5
is not yet available in Gentoo, the package has been masked. We recommend
that users unmerge LTSP:

    # emerge --unmerge net-misc/ltsp

If you have a requirement for Linux Terminal Servers, please either set up
a terminal server by hand or use one of the distributions that already
migrated to LTSP 5. If you want to contribute to the integration of LTSP 5
in Gentoo, or want to follow its development, find details in bug 177580.

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200805-07
http://bugs.gentoo.org/show_bug.cgi?id=215699
http://www.gentoo.org/security/en/glsa/glsa-200705-02.xml
http://www.gentoo.org/security/en/glsa/glsa-200705-06.xml
http://www.gentoo.org/security/en/glsa/glsa-200705-22.xml
http://www.gentoo.org/security/en/glsa/glsa-200705-24.xml
http://www.gentoo.org/security/en/glsa/glsa-200710-06.xml
http://www.gentoo.org/security/en/glsa/glsa-200710-16.xml
http://www.gentoo.org/security/en/glsa/glsa-200710-30.xml
http://www.gentoo.org/security/en/glsa/glsa-200711-08.xml
http://www.gentoo.org/security/en/glsa/glsa-200801-09.xml
https://bugs.gentoo.org/177580

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200805-07 (ltsp)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"net-misc/ltsp", unaffected: make_list(), vulnerable: make_list("lt 5.0"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
