# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(60622);
 script_cve_id("CVE-2008-1383");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200803-30 (ssl-cert.eclass)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200803-30.

An error in the usage of the ssl-cert eclass within multiple ebuilds might
allow for disclosure of generated SSL private keys.

Solution:
Upgrading to newer versions of the above packages will neither remove
possibly compromised SSL certificates, nor old binary packages. Please
remove the certificates installed by Portage, and then emerge an upgrade
to the package.

All Conserver users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=app-admin/conserver-8.1.16'

All Postfix 2.4 users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=mail-mta/postfix-2.4.6-r2'

All Postfix 2.3 users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=mail-mta/postfix-2.3.8-r1'

All Postfix 2.2 users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=mail-mta/postfix-2.2.11-r1'

All Netkit FTP Server users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=net-ftp/netkit-ftpd-0.17-r7'

All ejabberd users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=net-im/ejabberd-1.1.3'

All UnrealIRCd users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=net-irc/unrealircd-3.2.7-r2'

All Cyrus IMAP Server users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=net-mail/cyrus-imapd-2.3.9-r1'

All Dovecot users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=net-mail/dovecot-1.0.10'

All stunnel 4 users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=net-misc/stunnel-4.21'

All InterNetNews users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=net-nntp/inn-2.4.3-r1'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200803-30
http://bugs.gentoo.org/show_bug.cgi?id=174759

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200803-30 (ssl-cert.eclass)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"app-admin/conserver", unaffected: make_list("ge 8.1.16"), vulnerable: make_list("lt 8.1.16"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"mail-mta/postfix", unaffected: make_list("ge 2.4.6-r2", "rge 2.3.8-r1", "rge 2.2.11-r1"), vulnerable: make_list("lt 2.4.6-r2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"net-ftp/netkit-ftpd", unaffected: make_list("ge 0.17-r7"), vulnerable: make_list("lt 0.17-r7"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"net-im/ejabberd", unaffected: make_list("ge 1.1.3"), vulnerable: make_list("lt 1.1.3"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"net-irc/unrealircd", unaffected: make_list("ge 3.2.7-r2"), vulnerable: make_list("lt 3.2.7-r2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"net-mail/cyrus-imapd", unaffected: make_list("ge 2.3.9-r1"), vulnerable: make_list("lt 2.3.9-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"net-mail/dovecot", unaffected: make_list("ge 1.0.10"), vulnerable: make_list("lt 1.0.10"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"net-misc/stunnel", unaffected: make_list("ge 4.21-r1", "lt 4.0"), vulnerable: make_list("lt 4.21-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"net-nntp/inn", unaffected: make_list("ge 2.4.3-r1"), vulnerable: make_list("lt 2.4.3-r1"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
