# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(60221);
 script_cve_id("CVE-2007-5760", "CVE-2007-5958", "CVE-2007-6427", "CVE-2007-6428", "CVE-2007-6429", "CVE-2008-0006");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200801-09 (xorg-server libXfont)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200801-09.

Multiple vulnerabilities have been discovered in the X.Org X server and
Xfont library, allowing for a local privilege escalation and arbitrary
code execution.

Solution:
All X.Org X server users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=x11-base/xorg-server-1.3.0.0-r4'

All X.Org Xfont library users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=x11-libs/libXfont-1.3.1-r1'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200801-09
http://bugs.gentoo.org/show_bug.cgi?id=204362
http://lists.freedesktop.org/archives/xorg/2008-January/031918.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200801-09 (xorg-server libXfont)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"x11-base/xorg-server", unaffected: make_list("ge 1.3.0.0-r4"), vulnerable: make_list("lt 1.3.0.0-r4"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"x11-libs/libXfont", unaffected: make_list("ge 1.3.1-r1"), vulnerable: make_list("lt 1.3.1-r1"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
