# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(58544);
 script_cve_id("CVE-2007-3089", "CVE-2007-3656", "CVE-2007-3734", "CVE-2007-3735", "CVE-2007-3736", "CVE-2007-3737", "CVE-2007-3738", "CVE-2007-3844");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200708-09 (mozilla/thunderbird/firefox/xulrunner)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200708-09.

Multiple vulnerabilities have been reported in Mozilla Firefox,
Thunderbird, SeaMonkey and XULRunner, some of which may allow
user-assisted arbitrary remote code execution.

For details on the issues addressed with this update,
please visit the referenced security advisories.

Solution:
Apply the appropriate updates.

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200708-09
http://bugs.gentoo.org/show_bug.cgi?id=185737
http://bugs.gentoo.org/show_bug.cgi?id=187205

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200708-09 (mozilla/thunderbird/firefox/xulrunner)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"www-client/mozilla-firefox", unaffected: make_list("ge 2.0.0.6"), vulnerable: make_list("lt 2.0.0.6"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"www-client/mozilla-firefox-bin", unaffected: make_list("ge 2.0.0.6"), vulnerable: make_list("lt 2.0.0.6"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"mail-client/mozilla-thunderbird", unaffected: make_list("ge 2.0.0.6"), vulnerable: make_list("lt 2.0.0.6"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"mail-client/mozilla-thunderbird-bin", unaffected: make_list("ge 2.0.0.6"), vulnerable: make_list("lt 2.0.0.6"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"www-client/seamonkey", unaffected: make_list("ge 1.1.4"), vulnerable: make_list("lt 1.1.4"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"www-client/seamonkey-bin", unaffected: make_list("ge 1.1.4"), vulnerable: make_list("lt 1.1.4"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"net-libs/xulrunner", unaffected: make_list("ge 1.8.1.6"), vulnerable: make_list("lt 1.8.1.6"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
