# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(58063);
 script_cve_id("CVE-2006-6077", "CVE-2007-0775", "CVE-2007-0776", "CVE-2007-0777", "CVE-2007-0778", "CVE-2007-0779", "CVE-2007-0780", "CVE-2007-0800", "CVE-2007-0801", "CVE-2007-0981", "CVE-2007-0995");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200703-04 (mozilla-firefox)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200703-04.

Multiple vulnerabilities have been reported in Mozilla Firefox, some of
which may allow user-assisted arbitrary remote code execution.

Solution:
Users upgrading to the following releases of Mozilla Firefox should note
that this upgrade has been found to lose the saved passwords file in some
cases. The saved passwords are encrypted and stored in the 'signons.txt'
file of ~/.mozilla/ and we advise our users to save that file before
performing the upgrade.

All Mozilla Firefox 1.5 users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=www-client/mozilla-firefox-1.5.0.10'

All Mozilla Firefox 1.5 binary users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=www-client/mozilla-firefox-bin-1.5.0.10'

All Mozilla Firefox 2.0 users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=www-client/mozilla-firefox-2.0.0.2'

All Mozilla Firefox 2.0 binary users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=www-client/mozilla-firefox-bin-2.0.0.2'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200703-04
http://bugs.gentoo.org/show_bug.cgi?id=165555
https://bugzilla.mozilla.org/show_bug.cgi?id=360493#c366

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200703-04 (mozilla-firefox)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"www-client/mozilla-firefox", unaffected: make_list("rge 1.5.0.10", "ge 2.0.0.2"), vulnerable: make_list("lt 2.0.0.2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"www-client/mozilla-firefox-bin", unaffected: make_list("rge 1.5.0.10", "ge 2.0.0.2"), vulnerable: make_list("lt 2.0.0.2"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
