# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(57846);
 script_cve_id("CVE-2006-3627", "CVE-2006-3628", "CVE-2006-3629", "CVE-2006-3630", "CVE-2006-3631", "CVE-2006-3632");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200607-09 (wireshark ethereal)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200607-09.

Wireshark (formerly known as Ethereal) is vulnerable to several security
issues, potentially allowing the execution of arbitrary code by a remote
attacker.

Solution:
All Wireshark users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=net-analyzer/wireshark-0.99.2'

All Ethereal users should migrate to Wireshark:

    # emerge --sync
    # emerge --ask --unmerge net-analyzer/ethereal
    # emerge --ask --oneshot --verbose '>=net-analyzer/wireshark-0.99.2'

To keep the [saved] configuration from Ethereal and reuse it with
Wireshark:

    # mv ~/.ethereal ~/.wireshark

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200607-09
http://bugs.gentoo.org/show_bug.cgi?id=140856
http://www.wireshark.org/security/wnpa-sec-2006-01.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200607-09 (wireshark ethereal)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"net-analyzer/wireshark", unaffected: make_list("ge 0.99.2"), vulnerable: make_list("lt 0.99.2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"net-analyzer/ethereal", unaffected: make_list(), vulnerable: make_list("le 0.99.0-r1"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
