# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(56077);
 script_cve_id("CVE-2005-3191", "CVE-2005-3192", "CVE-2005-3193", "CVE-2005-3624", "CVE-2005-3625", "CVE-2005-3626", "CVE-2005-3627");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200601-02 (kdegraphics, kpdf, koffice, kword)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200601-02.

KPdf and KWord both include vulnerable Xpdf code to handle PDF files,
making them vulnerable to the execution of arbitrary code.

Solution:
All kdegraphics users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=kde-base/kdegraphics-3.4.3-r3'

All Kpdf users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=kde-base/kpdf-3.4.3-r3'

All KOffice users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=app-office/koffice-1.4.2-r6'

All KWord users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=app-office/kword-1.4.2-r6'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200601-02
http://bugs.gentoo.org/show_bug.cgi?id=114429
http://bugs.gentoo.org/show_bug.cgi?id=115851
http://www.gentoo.org/security/en/glsa/glsa-200512-08.xml
http://www.kde.org/info/security/advisory-20051207-2.txt

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200601-02 (kdegraphics, kpdf, koffice, kword)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"kde-base/kdegraphics", unaffected: make_list("ge 3.4.3-r3"), vulnerable: make_list("lt 3.4.3-r3"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"kde-base/kpdf", unaffected: make_list("ge 3.4.3-r3"), vulnerable: make_list("lt 3.4.3-r3"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"app-office/koffice", unaffected: make_list("ge 1.4.2-r6"), vulnerable: make_list("lt 1.4.2-r6"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"app-office/kword", unaffected: make_list("ge 1.4.2-r6"), vulnerable: make_list("lt 1.4.2-r6"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
