# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(55891);
 script_cve_id("CVE-2005-2975", "CVE-2005-2976", "CVE-2005-3186");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200511-14 (gtk+)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200511-14.

The GdkPixbuf library, that is also included in GTK+ 2, contains
vulnerabilities that could lead to a Denial of Service or the execution of
arbitrary code.

Solution:
All GTK+ 2 users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose x11-libs/gtk+

All GdkPixbuf users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=media-libs/gdk-pixbuf-0.22.0-r5'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200511-14
http://bugs.gentoo.org/show_bug.cgi?id=112608
http://www.idefense.com/application/poi/display?id=339&type=vulnerabilities

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200511-14 (gtk+)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"x11-libs/gtk+", unaffected: make_list("ge 2.8.6-r1", "rge 2.6.10-r1", "lt 2.0"), vulnerable: make_list("lt 2.8.6-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"media-libs/gdk-pixbuf", unaffected: make_list("ge 0.22.0-r5"), vulnerable: make_list("lt 0.22.0-r5"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
