# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(55857);
 script_cve_id("CVE-2005-3054", "CVE-2005-3319", "CVE-2005-3388", "CVE-2005-3389", "CVE-2005-3390", "CVE-2005-3391", "CVE-2005-3392");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200511-08 (PHP)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200511-08.

PHP suffers from multiple issues, resulting in security functions bypass,
local Denial of service, cross-site scripting or PHP variables overwrite.

Solution:
All PHP users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose dev-php/php

All mod_php users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose dev-php/mod_php

All php-cgi users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose dev-php/php-cgi

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200511-08
http://bugs.gentoo.org/show_bug.cgi?id=107602
http://bugs.gentoo.org/show_bug.cgi?id=111032

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200511-08 (PHP)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"dev-php/php", unaffected: make_list("rge 4.3.11-r4", "ge 4.4.0-r4"), vulnerable: make_list("lt 4.4.0-r4"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"dev-php/mod_php", unaffected: make_list("rge 4.3.11-r4", "ge 4.4.0-r8"), vulnerable: make_list("lt 4.4.0-r8"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"dev-php/php-cgi", unaffected: make_list("rge 4.3.11-r5", "ge 4.4.0-r5"), vulnerable: make_list("lt 4.4.0-r5"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
