# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54985);
 script_cve_id("CVE-2005-1625");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200507-09 (acroread)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200507-09.

Adobe Acrobat Reader is vulnerable to a buffer overflow that could lead to
remote execution of arbitrary code.

Solution:
Since Adobe will most likely not update the 5.0 series of Adobe Acrobat
Reader for Linux, all users should upgrade to the latest available version
of the 7.0 series:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=app-text/acroread-7.0'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200507-09
http://bugs.gentoo.org/show_bug.cgi?id=98101
http://www.idefense.com/application/poi/display?id=279&type=vulnerabilities&flashstatus=true
http://www.adobe.com/support/techdocs/329083.html

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200507-09 (acroread)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"app-text/acroread", unaffected: make_list("ge 7.0"), vulnerable: make_list("le 5.10"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
