# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54944);
 script_cve_id("CVE-2005-1409", "CVE-2005-1410");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200505-12 (postgresql)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200505-12.

PostgreSQL is vulnerable to Denial of Service attacks and possibly allows
unprivileged users to gain administrator rights.

Solution:
http://www.postgresql.org/about/news.315

    # emerge --sync
    # emerge --ask --oneshot --verbose dev-db/postgresql

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200505-12
http://bugs.gentoo.org/show_bug.cgi?id=91231
http://www.postgresql.org/about/news.315
http://cve.mitre.org/cgi-bin/cvename.cgi?name=2005-1409
http://cve.mitre.org/cgi-bin/cvename.cgi?name=2005-1410
http://www.postgresql.org/about/news.315

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200505-12 (postgresql)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"dev-db/postgresql", unaffected: make_list("rge 7.4.7-r2", "rge 8.0.1-r3", "ge 8.0.2-r1"), vulnerable: make_list("lt 8.0.2-r1"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
