# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54773);
 script_cve_id("CVE-2004-1019", "CVE-2004-1065");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200412-14 (PHP)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200412-14.

Several vulnerabilities were found and fixed in PHP, ranging from an
information leak and a safe_mode restriction bypass to a potential remote
execution of arbitrary code.

Solution:
All PHP users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=dev-php/php-4.3.10'

All mod_php users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=dev-php/mod_php-4.3.10'

All php-cgi users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=dev-php/php-cgi-4.3.10'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200412-14
http://bugs.gentoo.org/show_bug.cgi?id=74547
http://www.php.net/release_4_3_10.php
http://www.hardened-php.net/advisories/012004.txt
http://www.securityfocus.com/archive/1/384663/2004-12-15/2004-12-21/0

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200412-14 (PHP)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"dev-php/php", unaffected: make_list("ge 4.3.10"), vulnerable: make_list("lt 4.3.10"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"dev-php/mod_php", unaffected: make_list("ge 4.3.10"), vulnerable: make_list("lt 4.3.10"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"dev-php/php-cgi", unaffected: make_list("ge 4.3.10"), vulnerable: make_list("lt 4.3.10"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
