# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54682);
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200409-26 (Mozilla)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200409-26.

New releases of Mozilla, Epiphany, Mozilla Thunderbird, and Mozilla Firefox
fix several vulnerabilities, including the remote execution of arbitrary
code.

Solution:
All users should upgrade to the latest stable version:

    # emerge sync

    # emerge -pv your-version
    # emerge your-version

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200409-26
http://bugs.gentoo.org/show_bug.cgi?id=63996
http://www.mozilla.org/projects/security/known-vulnerabilities.html#mozilla1.7.3
http://www.us-cert.gov/cas/techalerts/TA04-261A.html

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200409-26 (Mozilla)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"net-www/mozilla", unaffected: make_list("ge 1.7.3"), vulnerable: make_list("lt 1.7.3"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"net-www/mozilla-firefox", unaffected: make_list("ge 1.0_pre"), vulnerable: make_list("lt 1.0_pre"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"mail-client/mozilla-thunderbird", unaffected: make_list("ge 0.8"), vulnerable: make_list("lt 0.8"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"net-www/mozilla-bin", unaffected: make_list("ge 1.7.3"), vulnerable: make_list("lt 1.7.3"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"net-www/mozilla-firefox-bin", unaffected: make_list("ge 1.0_pre"), vulnerable: make_list("lt 1.0_pre"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"mail-client/mozilla-thunderbird-bin", unaffected: make_list("ge 0.8"), vulnerable: make_list("lt 0.8"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"net-www/epiphany", unaffected: make_list("ge 1.2.9-r1"), vulnerable: make_list("lt 1.2.9-r1"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
