# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54610);
 script_bugtraq_id(10619);
 script_cve_id("CVE-2004-0493");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200407-03 (Apache)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200407-03.

A bug in Apache may allow a remote attacker to perform a Denial of Service
attack. With certain configurations this could lead to a heap based buffer
overflow.

Solution:
Apache 2 users should upgrade to the latest version of Apache:

    # emerge sync

    # emerge -pv '>=net-www/apache-2.0.49-r4'
    # emerge '>=net-www/apache-2.0.49-r4'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200407-03
http://bugs.gentoo.org/show_bug.cgi?id=55441
http://www.guninski.com/httpd1.html

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200407-03 (Apache)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"net-www/apache", unaffected: make_list("ge 2.0.49-r4", "lt 2"), vulnerable: make_list("le 2.0.49-r3"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
