# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54524);
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200402-06 (Kernel)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200402-06.

A vulnerability has been discovered by in the ptrace emulation code for
AMD64 platforms when eflags are processed, allowing a local user to obtain
elevated priveleges.

Solution:
Users are encouraged to upgrade to the latest available sources for their
system:

    # emerge sync
    # emerge -pv your-favourite-sources
    # emerge your-favourite-sources
    # # Follow usual procedure for compiling and installing a kernel.
    # # If you use genkernel, run genkernel as you would do normally.
    

    # # IF YOUR KERNEL IS MARKED as 'remerge required!' THEN
    # # YOU SHOULD UPDATE YOUR KERNEL EVEN IF PORTAGE
    # # REPORTS THAT THE SAME VERSION IS INSTALLED.
    

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200402-06

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200402-06 (Kernel)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"sys-kernel/ck-sources", unaffected: make_list("ge 2.6.2"), vulnerable: make_list("lt 2.6.2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/development-sources", unaffected: make_list("ge 2.6.2"), vulnerable: make_list("lt 2.6.2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/gentoo-dev-sources", unaffected: make_list("ge 2.6.2"), vulnerable: make_list("lt 2.6.2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/gentoo-sources", unaffected: make_list("ge 2.4.22-r6"), vulnerable: make_list("lt 2.4.22-r6"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/gentoo-test-sources", unaffected: make_list("ge 2.6.2-r1"), vulnerable: make_list("lt 2.6.2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/gs-sources", unaffected: make_list("ge 2.4.25_pre7-r1"), vulnerable: make_list("lt 2.4.25_pre7-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/vanilla-prepatch-sources", unaffected: make_list("ge 2.4.25_rc3"), vulnerable: make_list("lt 2.4.25_rc3"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/vanilla-sources", unaffected: make_list("ge 2.4.24-r1"), vulnerable: make_list("lt 2.4.24-r1"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
