# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54508);
 script_bugtraq_id(9138);
 script_cve_id("CVE-2003-0961");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200312-02 (Kernel)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200312-02.

A flaw in the do_brk() function of the Linux kernel 2.4.22 and earlier can
be exploited by local users or malicious services to gain root privileges.

Solution:
It is recommended that all Gentoo Linux users upgrade their machines to use
the latest stable version of their preferred kernel sources.

    # emerge sync
    # emerge -pv [your preferred kernel sources]
    # emerge [your preferred kernel sources]
    # [update the /usr/src/linux symlink]
    # [compile and install your new kernel]
    # [emerge any necessary kernel module ebuilds]
    # [reboot]

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200312-02
http://bugs.gentoo.org/show_bug.cgi?id=34844

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200312-02 (Kernel)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"aa-sources", unaffected: make_list("ge 2.4.23_pre6-r3"), vulnerable: make_list("lt 2.4.23_pre6-r3"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"ck-sources", unaffected: make_list("ge 2.4.22-r3"), vulnerable: make_list("lt 2.4.22-r3"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"gentoo-sources", unaffected: make_list("ge 2.4.20-r9"), vulnerable: make_list("lt 2.4.20-r9"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"gentoo-sources", unaffected: make_list("ge 2.4.22-r1"), vulnerable: make_list("lt 2.4.22-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"grsec-sources", unaffected: make_list("ge 2.4.22.1.9.12-r1"), vulnerable: make_list("lt 2.4.22.1.9.12-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"grsec-sources", unaffected: make_list("ge 2.4.22.2.0_rc3-r1"), vulnerable: make_list("lt 2.4.22.2.0_rc3-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"gs-sources", unaffected: make_list("ge 2.4.23_pre8-r1"), vulnerable: make_list("lt 2.4.23_pre8-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"hardened-sources", unaffected: make_list("ge 2.4.22-r1"), vulnerable: make_list("lt 2.4.22-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"hardened-sources", unaffected: make_list("ge 2.4.22-r1"), vulnerable: make_list("lt 2.4.22-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"ia64-sources", unaffected: make_list("ge 2.4.22-r1"), vulnerable: make_list("lt 2.4.22-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"mips-sources", unaffected: make_list("ge 2.4.22-r4"), vulnerable: make_list("lt 2.4.22-r4"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"mips-sources", unaffected: make_list("ge 2.4.22-r5"), vulnerable: make_list("lt 2.4.22-r5"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"openmosix-sources", unaffected: make_list("ge 2.4.22-r1"), vulnerable: make_list("lt 2.4.22-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"ppc-sources", unaffected: make_list("ge 2.4.22-r3"), vulnerable: make_list("lt 2.4.22-r3"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"ppc-sources-benh", unaffected: make_list("ge 2.4.20-r9"), vulnerable: make_list("lt 2.4.20-r9"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"ppc-sources-benh", unaffected: make_list("ge 2.4.21-r2"), vulnerable: make_list("lt 2.4.21-r2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"ppc-sources-benh", unaffected: make_list("ge 2.4.22-r3"), vulnerable: make_list("lt 2.4.22-r3"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"ppc-sources-crypto", unaffected: make_list("ge 2.4.20-r1"), vulnerable: make_list("lt 2.4.20-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"selinux-sources", unaffected: make_list("ge 2.4.21-r5"), vulnerable: make_list("lt 2.4.21-r5"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sparc-sources", unaffected: make_list("ge 2.4.23"), vulnerable: make_list("lt 2.4.23"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"usermode-sources", unaffected: make_list("ge 2.4.22-r1"), vulnerable: make_list("lt 2.4.22-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"wolk-sources", unaffected: make_list("ge 4.10_pre7-r1"), vulnerable: make_list("lt 4.10_pre7-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"wolk-sources", unaffected: make_list("ge 4.9-r2"), vulnerable: make_list("lt 4.9-r2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"xfs-sources", unaffected: make_list("ge 2.4.20-r4"), vulnerable: make_list("lt 2.4.20-r4"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
