###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_vmware_prdts_vix_api_mult_vuln.nasl 0290 2008-09-29 10:37:44Z sep $
#
# VMware VIX API Multiple Buffer Overflow Vulnerabilities (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800007);
  script_version("$Revision: 1.1 $");
  script_cve_id("CVE-2008-2100");
  script_bugtraq_id(29552);
  script_xref(name:"CB-A", value:"08-0093");
  script_name(english:"VMware VIX API Multiple Buffer Overflow Vulnerabilities (Win)");
  desc["english"] = "

  Overview : The host is installed with VMWare product(s) that are vulnerable
  to multiple buffer overflow.

  Vulnerability Insight:
  VMware VIX API (Application Program Interface) fails to adequately bounds
  check user supplied input before copying it to insufficient size buffer.

  Impact : Successful exploitation allow attackers to execute arbitrary code
  on the affected system and local user can obtain elevated privileges on the
  target system.

  Successful exploitation requires that the vix.inGuest.enable configuration
  value is enabled.

  Impact Level : System

  Affected Software/OS:
  VMware Player 1.x - before 1.0.7 build 91707 on Windows
  VMware Player 2.x - before 2.0.4 build 93057 on Windows
  VMware Server 1.x - before 1.0.6 build 91891 on Windows
  VMware Workstation 5.x - before 5.5.7 build 91707 on Windows
  VMware Workstation 6.x - before 6.0.4 build 93057 on Windows
  VMware ACE 2.x - before 2.0.4 build 93057 on Windows

  Fix:
  Upgrade VMware Product(s) to below version,
  VMware Player 1.0.7 build 91707 or 2.0.4 build 93057 or later
  www.vmware.com/download/player/ 
  
  VMware Server 1.0.6 build 91891 or later
  www.vmware.com/download/server/ 
  
  VMware Workstation 5.5.7 build 91707 or 6.0.4 build 93057 or later
  www.vmware.com/download/ws/

  VMware ACE 2.0.4 build 93057
  http://www.vmware.com/download/ace/
 
  References:
  http://secunia.com/advisories/30556
  http://www.vmware.com/security/advisories/VMSA-2008-0009.html

  CVSS Score:
    CVSS Base Score     : 6.0 (AV:N/AC:M/Au:SI/C:P/I:P/A:P)
    CVSS Temporal Score : 4.4
  Risk factor : Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of VMware Products");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Misc.");
  script_dependencies("gb_vmware_prdts_detect_win.nasl");
  exit(0);
}


if(!get_kb_item("VMware/Win/Installed")){ # Is VMWare installed?
  exit(0);
}

# VMware Player
vmplayerVer = get_kb_item("VMware/Player/Win/Ver");
if(vmplayerVer)
{
  if(ereg(pattern:"^(1\.0(\.[0-6])?|2\.0(\.[0-3])?)$",
          string:vmplayerVer)){
    security_warning(0);
  }
  exit(0);
}

# VMware Server
vmserverVer = get_kb_item("VMware/Server/Win/Ver");
if(vmserverVer)
{
  if(ereg(pattern:"^1\.0(\.[0-5])?$", string:vmserverVer)){
    security_warning(0);
  }
  exit(0);
}

# VMware Workstation
vmworkstnVer = get_kb_item("VMware/Workstation/Win/Ver");
if(vmworkstnVer)
{
  if(ereg(pattern:"^(5\.([0-4](\..*)?|5(\.[0-6])?)|6\.0(\.[0-3])?)$",
          string:vmworkstnVer)){
    security_warning(0);
  }
  exit(0);
}

# VMware ACE
vmaceVer = get_kb_item("VMware/ACE/Win/Ver");
if(!vmaceVer){
  vmaceVer = get_kb_item("VMware/ACE\Dormant/Win/Ver");
}

if(vmaceVer)
{
  if(ereg(pattern:"^2\.0(\.[0-3])?$", string:vmaceVer)){
    security_warning(0);
  }
}
