###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for libcdio vulnerability USN-580-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840333);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "580-1");
  script_cve_id("CVE-2007-6613");
  script_name(english: "Ubuntu Update for libcdio vulnerability USN-580-1");
  desc["english"] = "

  Vulnerability Insight:

  Devon Miller discovered that the iso-info and cd-info tools did not
  properly perform bounds checking. If a user were tricked into using
  these tools with a crafted iso image, an attacker could cause a
  denial of service via a core dump, and possibly execute arbitrary
  code.

  Affected Software/OS:
  libcdio vulnerability on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-February/000667.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libcdio vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libcdio-dev", ver:"0.76-1ubuntu2.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio6", ver:"0.76-1ubuntu2.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio-cdda-dev", ver:"0.76-1ubuntu2.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio-cdda0", ver:"0.76-1ubuntu2.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio-paranoia-dev", ver:"0.76-1ubuntu2.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio-paranoia0", ver:"0.76-1ubuntu2.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libiso9660-4", ver:"0.76-1ubuntu2.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libiso9660-dev", ver:"0.76-1ubuntu2.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libcdio-dev", ver:"0.76-1ubuntu1.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio6", ver:"0.76-1ubuntu1.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio-cdda-dev", ver:"0.76-1ubuntu1.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio-cdda0", ver:"0.76-1ubuntu1.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio-paranoia-dev", ver:"0.76-1ubuntu1.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio-paranoia0", ver:"0.76-1ubuntu1.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libiso9660-4", ver:"0.76-1ubuntu1.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libiso9660-dev", ver:"0.76-1ubuntu1.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"libcdio-dev", ver:"0.76-1ubuntu1.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio6", ver:"0.76-1ubuntu1.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio-cdda-dev", ver:"0.76-1ubuntu1.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio-cdda0", ver:"0.76-1ubuntu1.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio-paranoia-dev", ver:"0.76-1ubuntu1.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio-paranoia0", ver:"0.76-1ubuntu1.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libiso9660-4", ver:"0.76-1ubuntu1.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libiso9660-dev", ver:"0.76-1ubuntu1.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libcdio-dev", ver:"0.76-1ubuntu2.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio6", ver:"0.76-1ubuntu2.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio-cdda-dev", ver:"0.76-1ubuntu2.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio-cdda0", ver:"0.76-1ubuntu2.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio-paranoia-dev", ver:"0.76-1ubuntu2.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcdio-paranoia0", ver:"0.76-1ubuntu2.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libiso9660-4", ver:"0.76-1ubuntu2.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libiso9660-dev", ver:"0.76-1ubuntu2.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}