###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for php5 vulnerabilities USN-462-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840071);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "462-1");
  script_cve_id("CVE-2007-2509", "CVE-2007-2510", "CVE-2007-2511", "CVE-2007-2519");
  script_name(english: "Ubuntu Update for php5 vulnerabilities USN-462-1");
  desc["english"] = "

  Vulnerability Insight:

  A flaw was discovered in the FTP command handler in PHP.  Commands were
  not correctly filtered for control characters.  An attacker could issue
  arbitrary FTP commands using specially crafted arguments.  (CVE-2007-2509)
  
  Ilia Alshanetsky discovered a buffer overflow in the SOAP request handler
  in PHP.  Remote attackers could send a specially crafted SOAP request
  and execute arbitrary code with web server privileges.  (CVE-2007-2510)
  
  Ilia Alshanetsky discovered a buffer overflow in the user filter factory
  in PHP.  A local attacker could create a specially crafted script and
  execute arbitrary code with web server privileges.  (CVE-2007-2511)
  
  Gregory Beaver discovered that the PEAR installer did not validate
  installation paths.  If a user were tricked into installing a malicious
  PEAR package, an attacker could overwrite arbitrary files.  (CVE-2007-2519)

  Affected Software/OS:
  php5 vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-May/000534.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of php5 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cgi", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cli", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-common", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-curl", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-dev", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-gd", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-ldap", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mhash", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mysql", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-odbc", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-pspell", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-recode", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-snmp", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sybase", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-tidy", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xsl", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php-pear", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5", ver:"5.2.1-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cgi", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cli", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-common", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-curl", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-dev", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-gd", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-ldap", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mhash", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mysql", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mysqli", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-odbc", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-recode", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-snmp", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sybase", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xsl", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php-pear", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5", ver:"5.1.2-1ubuntu3.8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cgi", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cli", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-common", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-curl", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-dev", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-gd", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-ldap", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mhash", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mysql", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mysqli", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-odbc", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-recode", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-snmp", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sybase", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xsl", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php-pear", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5", ver:"5.1.6-1ubuntu2.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}