###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for krb5 vulnerabilities USN-449-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840098);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "449-1");
  script_cve_id("CVE-2007-0956", "CVE-2007-0957", "CVE-2007-1216");
  script_name(english: "Ubuntu Update for krb5 vulnerabilities USN-449-1");
  desc["english"] = "

  Vulnerability Insight:

  The krb5 telnet service did not appropriately verify user names.  A
  remote attacker could log in as the root user by requesting a specially
  crafted user name. (CVE-2007-0956)
  
  The krb5 syslog library did not correctly verify the size of log
  messages.  A remote attacker could send a specially crafted message and
  execute arbitrary code with root privileges. (CVE-2007-0957)
  
  The krb5 administration service was vulnerable to a double-free in the
  GSS RPC library.  A remote attacker could send a specially crafted
  request and execute arbitrary code with root privileges. (CVE-2007-1216)

  Affected Software/OS:
  krb5 vulnerabilities on Ubuntu 5.10 ,
  Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-April/000517.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of krb5 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.4.3-5ubuntu0.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-clients", ver:"1.4.3-5ubuntu0.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.4.3-5ubuntu0.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.4.3-5ubuntu0.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.4.3-5ubuntu0.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.4.3-5ubuntu0.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-user", ver:"1.4.3-5ubuntu0.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkadm55", ver:"1.4.3-5ubuntu0.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.4.3-5ubuntu0.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb53", ver:"1.4.3-5ubuntu0.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-doc", ver:"1.4.3-5ubuntu0.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.4.3-9ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-clients", ver:"1.4.3-9ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.4.3-9ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.4.3-9ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.4.3-9ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.4.3-9ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-user", ver:"1.4.3-9ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkadm55", ver:"1.4.3-9ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5-dbg", ver:"1.4.3-9ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.4.3-9ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb53", ver:"1.4.3-9ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-doc", ver:"1.4.3-9ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU5.10")
{

  if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.3.6-4ubuntu0.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-clients", ver:"1.3.6-4ubuntu0.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.3.6-4ubuntu0.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.3.6-4ubuntu0.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.3.6-4ubuntu0.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.3.6-4ubuntu0.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-user", ver:"1.3.6-4ubuntu0.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkadm55", ver:"1.3.6-4ubuntu0.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.3.6-4ubuntu0.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb53", ver:"1.3.6-4ubuntu0.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-doc", ver:"1.3.6-4ubuntu0.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}