###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for Sun Java SUSE-SA:2007:055
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850067);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-055");
  script_cve_id("CVE-2007-5232", "CVE-2007-5236", "CVE-2007-5237", "CVE-2007-5238", "CVE-2007-5239", "CVE-2007-5240", "CVE-2007-5273", "CVE-2007-5274");
  script_name(english: "SuSE Update for Sun Java SUSE-SA:2007:055");
  desc["english"] = "

  Vulnerability Insight:

  The Sun JAVA JDK 1.5.0 was upgraded to release 13, and the Sun JAVA
  SDK 1.4.2 was upgraded to update 16 to fix various bugs, including
  the following security bugs:

  http://sunsolve.sun.com/search/document.do?assetkey=1-26-103079-1

  CVE-2007-5232: Sun Java Runtime Environment (JRE) in JDK and JRE
  6 Update 2 and earlier, JDK and JRE 5.0 Update 12 and earlier, SDK
  and JRE 1.4.2_15 and earlier, and SDK and JRE 1.3.1_20 and earlier,
  when applet caching is enabled, allows remote attackers to violate
  the security model for an applets outbound connections via a DNS
  rebinding attack.

  http://sunsolve.sun.com/search/document.do?assetkey=1-26-103073-1

  CVE-2007-5236: Java Web Start in Sun JDK and JRE 5.0 Update 12 and
  earlier, and SDK and JRE 1.4.2_15 and earlier, on Windows does not
  properly enforce access restrictions for untrusted applications,
  which allows user-assisted remote attackers to read local files via
  an untrusted application.

  CVE-2007-5237: Java Web Start in Sun JDK and JRE 6 Update 2 and
  earlier does not properly enforce access restrictions for untrusted
  applications, which allows user-assisted remote attackers to read
  and modify local files via an untrusted application, aka &quot;two
  vulnerabilities&quot;.

  CVE-2007-5238: Java Web Start in Sun JDK and JRE 6 Update 2 and
  earlier, JDK and JRE 5.0 Update 12 and earlier, and SDK and JRE
  1.4.2_15 and earlier does not properly enforce access restrictions for
  untrusted applications, which allows user-assisted remote attackers
  to obtain sensitive information (the Java Web Start cache location)
  via an untrusted application, aka &quot;three vulnerabilities.&quot;

  http://sunsolve.sun.com/search/document.do?assetkey=1-26-103072-1

  CVE-2007-5239: Java Web Start in Sun JDK and JRE 6 Update 2 and
  earlier, JDK and JRE 5.0 Update 12 and earlier, SDK and JRE 1.4.2_15
  and earlier, and SDK and JRE 1.3.1_20 and earlier does not properly
  enforce access restrictions for untrusted (1) applications and (2)
  applets, which allows user-assisted remote attackers to copy or rename
  arbitrary files when local users perform drag-and-drop operations
  from the untrusted application or applet window onto certain types
  of desktop applications.

  http://sunsolve.sun.com/se ... 

  Description truncated, for more information please check the Reference URL

  Impact:
  remote code execution

  Affected Software/OS:
  Sun Java on SUSE LINUX 10.1, openSUSE 10.2, openSUSE 10.3, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE Linux Enterprise Desktop 10 SP1, SUSE Linux Enterprise Server 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_55_java.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of Sun Java");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"java-1_5_0-sun", rpm:"java-1_5_0-sun~1.5.0_update13~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun-alsa", rpm:"java-1_5_0-sun-alsa~1.5.0_update13~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun-demo", rpm:"java-1_5_0-sun-demo~1.5.0_update13~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun-devel", rpm:"java-1_5_0-sun-devel~1.5.0_update13~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun-jdbc", rpm:"java-1_5_0-sun-jdbc~1.5.0_update13~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun-plugin", rpm:"java-1_5_0-sun-plugin~1.5.0_update13~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun-src", rpm:"java-1_5_0-sun-src~1.5.0_update13~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_6_0-sun", rpm:"java-1_6_0-sun~1.6.0.u3~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_6_0-sun-alsa", rpm:"java-1_6_0-sun-alsa~1.6.0.u3~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_6_0-sun-demo", rpm:"java-1_6_0-sun-demo~1.6.0.u3~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_6_0-sun-devel", rpm:"java-1_6_0-sun-devel~1.6.0.u3~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_6_0-sun-jdbc", rpm:"java-1_6_0-sun-jdbc~1.6.0.u3~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_6_0-sun-plugin", rpm:"java-1_6_0-sun-plugin~1.6.0.u3~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"java-1_4_2-sun", rpm:"java-1_4_2-sun~1.4.2_update16~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-alsa", rpm:"java-1_4_2-sun-alsa~1.4.2_update16~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-demo", rpm:"java-1_4_2-sun-demo~1.4.2_update16~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-devel", rpm:"java-1_4_2-sun-devel~1.4.2_update16~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-jdbc", rpm:"java-1_4_2-sun-jdbc~1.4.2_update16~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-plugin", rpm:"java-1_4_2-sun-plugin~1.4.2_update16~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-src", rpm:"java-1_4_2-sun-src~1.4.2_update16~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun", rpm:"java-1_5_0-sun~1.5.0_update13~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun-alsa", rpm:"java-1_5_0-sun-alsa~1.5.0_update13~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun-demo", rpm:"java-1_5_0-sun-demo~1.5.0_update13~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun-devel", rpm:"java-1_5_0-sun-devel~1.5.0_update13~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun-jdbc", rpm:"java-1_5_0-sun-jdbc~1.5.0_update13~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun-plugin", rpm:"java-1_5_0-sun-plugin~1.5.0_update13~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun-src", rpm:"java-1_5_0-sun-src~1.5.0_update13~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"java2", rpm:"java2~1.4.2~129.32", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java2-jre", rpm:"java2-jre~1.4.2~129.32", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"java2", rpm:"java2~1.4.2~129.32", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java2-jre", rpm:"java2-jre~1.4.2~129.32", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"java2", rpm:"java2~1.4.2~129.32", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java2-jre", rpm:"java2-jre~1.4.2~129.32", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"java2", rpm:"java2~1.4.2~129.32", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java2-jre", rpm:"java2-jre~1.4.2~129.32", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"java-1_4_2-sun", rpm:"java-1_4_2-sun~1.4.2.16~0.2", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-alsa", rpm:"java-1_4_2-sun-alsa~1.4.2.16~0.2", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-demo", rpm:"java-1_4_2-sun-demo~1.4.2.16~0.2", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-devel", rpm:"java-1_4_2-sun-devel~1.4.2.16~0.2", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-jdbc", rpm:"java-1_4_2-sun-jdbc~1.4.2.16~0.2", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-plugin", rpm:"java-1_4_2-sun-plugin~1.4.2.16~0.2", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-src", rpm:"java-1_4_2-sun-src~1.4.2.16~0.2", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"java-1_4_2-sun", rpm:"java-1_4_2-sun~1.4.2.16~0.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-alsa", rpm:"java-1_4_2-sun-alsa~1.4.2.16~0.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-demo", rpm:"java-1_4_2-sun-demo~1.4.2.16~0.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-devel", rpm:"java-1_4_2-sun-devel~1.4.2.16~0.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-jdbc", rpm:"java-1_4_2-sun-jdbc~1.4.2.16~0.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-plugin", rpm:"java-1_4_2-sun-plugin~1.4.2.16~0.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-src", rpm:"java-1_4_2-sun-src~1.4.2.16~0.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"java-1_4_2-sun", rpm:"java-1_4_2-sun~1.4.2.16~0.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-alsa", rpm:"java-1_4_2-sun-alsa~1.4.2.16~0.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-demo", rpm:"java-1_4_2-sun-demo~1.4.2.16~0.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-devel", rpm:"java-1_4_2-sun-devel~1.4.2.16~0.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-jdbc", rpm:"java-1_4_2-sun-jdbc~1.4.2.16~0.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-plugin", rpm:"java-1_4_2-sun-plugin~1.4.2.16~0.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-sun-src", rpm:"java-1_4_2-sun-src~1.4.2.16~0.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun", rpm:"java-1_5_0-sun~1.5.0_13~0.1", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun-alsa", rpm:"java-1_5_0-sun-alsa~1.5.0_13~0.1", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun-demo", rpm:"java-1_5_0-sun-demo~1.5.0_13~0.1", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun-devel", rpm:"java-1_5_0-sun-devel~1.5.0_13~0.1", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun-jdbc", rpm:"java-1_5_0-sun-jdbc~1.5.0_13~0.1", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun-plugin", rpm:"java-1_5_0-sun-plugin~1.5.0_13~0.1", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-sun-src", rpm:"java-1_5_0-sun-src~1.5.0_13~0.1", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}