###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for IBMJava2 SUSE-SA:2007:010
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850066);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-010");
  script_cve_id("CVE-2006-4339", "CVE-2006-4790", "CVE-2006-6731", "CVE-2006-6736", "CVE-2006-6737", "CVE-2006-6745");
  script_name(english: "SuSE Update for IBMJava2 SUSE-SA:2007:010");
  desc["english"] = "

  Vulnerability Insight:

  Various security problems and bugs have been fixed in the IBMJava
  JRE and SDK.

  The IBM Java packages were updated to:
  - IBM Java 1.4.2 to Service Refresh 7.
  - IBM JAVA 1.3.10 to Service Refresh 10.

  It contains several security fixes also fixed in SUN Java including:

  - CVE-2006-4339: fix for the RSA exponent padding attack.
  - CVE-2006-6737: 2 unspecified vulnerabilities that
  allow untrusted applets to access data in other applets.
  - CVE-2006-6745: Multiple unspecified vulnerabilities that allow
  applets to gain privileges related to serialization bugs in the JRE.
  - CVE-2006-6731: Multiple buffer overflows in java image handling
  routines that allow attackers to potentially read/write/execute
  local files.

  A full overview is at:
  http://www-128.ibm.com/developerworks/java/jdk/alerts/

  The update also contains important timezone updates:
  - US daylight saving time update starting 2007.
  - Western Australia daylight savings time introduction in December 2006.
  - A general update to current timezone data-set.

  Impact:
  remote code execution

  Affected Software/OS:
  IBMJava2 on SuSE Linux Enterprise Server 8, SUSE SLES 9, Open Enterprise Server, Novell Linux POS 9, SUSE SLES 10

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_10_ibmjava.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of IBMJava2");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "OES")
{

  if(isrpmvuln(pkg:"IBMJava2-JRE", rpm:"IBMJava2-JRE~1.4.2~0.76", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"IBMJava2-SDK", rpm:"IBMJava2-SDK~1.4.2~0.76", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"IBMJava2-JRE", rpm:"IBMJava2-JRE~1.4.2~0.76", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"IBMJava2-SDK", rpm:"IBMJava2-SDK~1.4.2~0.76", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES10")
{

  if(isrpmvuln(pkg:"java-1_4_2-ibm", rpm:"java-1_4_2-ibm~1.4.2.s4~23.10", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-ibm-devel", rpm:"java-1_4_2-ibm-devel~1.4.2.s4~23.10", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-ibm-jdbc", rpm:"java-1_4_2-ibm-jdbc~1.4.2.s4~23.10", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_4_2-ibm-plugin", rpm:"java-1_4_2-ibm-plugin~1.4.2.s4~23.10", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESSr8")
{

  if(isrpmvuln(pkg:"IBMJava2-JRE", rpm:"IBMJava2-JRE~1.3.1~237", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"IBMJava2-SDK", rpm:"IBMJava2-SDK~1.3.1~237", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"IBMJava2-JRE", rpm:"IBMJava2-JRE~1.4.2~0.76", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"IBMJava2-SDK", rpm:"IBMJava2-SDK~1.4.2~0.76", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}