###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for XFree86-server,xorg-x11-server,xloader SUSE-SA:2007:008
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850054);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-008");
  script_cve_id("CVE-2006-6101", "CVE-2006-6102", "CVE-2006-6103", "CVE-2006-5867", "CVE-2006-5974");
  script_name(english: "SuSE Update for XFree86-server,xorg-x11-server,xloader SUSE-SA:2007:008");
  desc["english"] = "

  Vulnerability Insight:

  This update fixes three memory corruptions within the X server which
  could be used by local attackers with access to this display to crash
  the X server and potentially execute code.

  CVE-2006-6101: Integer overflow in the ProcRenderAddGlyphs function
  in the Render extension for X.Org 6.8.2, 6.9.0, 7.0,
  and 7.1, and XFree86 X server, allows local users to
  execute arbitrary code via a crafted X protocol request
  that triggers memory corruption during processing of
  glyph management data structures.

  CVE-2006-6102: Integer overflow in the ProcDbeGetVisualInfo function
  in the DBE extension for X.Org 6.8.2, 6.9.0, 7.0,
  and 7.1, and XFree86 X server, allows local users to
  execute arbitrary code via a crafted X protocol request
  that triggers memory corruption during processing of
  unspecified data structures.

  CVE-2006-6103: Integer overflow in the ProcDbeSwapBuffers function in
  the DBE extension for X.Org 6.8.2, 6.9.0, 7.0, and 7.1,
  and XFree86 X server, allows local users to execute
  arbitrary code via a crafted X protocol request
  that triggers memory corruption during processing of
  unspecified data structures.

  Impact:
  local privilege escalation

  Affected Software/OS:
  XFree86-server,xorg-x11-server,xloader on Novell Linux Desktop 9, Novell Linux POS 9, Open Enterprise Server, openSUSE 10.2, SUSE LINUX 10.1, SuSE Linux Enterprise Server 8, SUSE SLED 10, SUSE SLES 10, SUSE SLES 9

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_08_x.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of XFree86-server,xorg-x11-server,xloader");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"xorg-x11-server", rpm:"xorg-x11-server~7.2~30.4", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES10")
{

  if(isrpmvuln(pkg:"xorg-x11-server", rpm:"xorg-x11-server~6.9.0~50.30", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESSr8")
{

  if(isrpmvuln(pkg:"xloader", rpm:"xloader~4.2.0~280", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.99.902~43.82", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.0~142", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.99.902~43.82", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.0~142", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.99.902~43.82", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.0~142", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.99.902~43.82", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.0~142", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"xorg-x11-server", rpm:"xorg-x11-server~6.9.0~50.30", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLED10")
{

  if(isrpmvuln(pkg:"xorg-x11-server", rpm:"xorg-x11-server~6.9.0~50.30", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}