###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mssql_sp_replwritetovarbin_bof_vuln.nasl 656 2008-12-16 16:02:14Z dec $
#
# Microsoft SQL Server sp_replwritetovarbin() BOF Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800082);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5416", "CVE-2008-4270");
  script_bugtraq_id(32710);
  script_name(english:"Microsoft SQL Server sp_replwritetovarbin() BOF Vulnerability");
  desc["english"] = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-004.

  Vulnerability Insight:
  The flaw is caused due to a boundary error in the implementation of the
  function sp_replwritetovarbin() SQL procedure.

  Impact:
  Successful exploitation could result in heap based buffer overflow via
  specially crafted arguments passed to the affected application.

  Impact Level: Application

  Affected Software/OS:
  Microsoft SQL Server 2000 and 2005 on Windows.

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms09-004.mspx

  References:
  http://securitytracker.com/alerts/2008/Dec/1021363.html
  http://www.microsoft.com/technet/security/advisory/961040.mspx
  http://www.microsoft.com/technet/security/bulletin/ms09-004.mspx
  http://www.securityfocus.com/archive/1/archive/1/499042/100/0/threaded
  http://www.sec-consult.com/files/20081209_mssql-2000-sp_replwritetovarbin_memwrite.txt

  CVSS Score:
    CVSS Base Score     : 9.0 (AV:N/AC:L/Au:SI/C:C/I:C/A:C)
    CVSS Temporal Score : 7.1
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Microsoft SQL Server");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Denial of Service");
  script_dependencies("secpod_reg_enum.nasl", "mssql_version.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(1433, "Services/mssql");
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

mssqlPort = get_kb_item("Services/mssql");
if(!mssqlPort){
  mssqlPort = 1433;
}

if(!get_port_state(mssqlPort)){
  exit(0);
}

function Get_FileVersion(ver, path)
{
  if(ver == "MS SQL Server 2005")
  {
    item = "SQLBinRoot";
    file = "\sqlservr.exe";
  }

  if(ver == "MS SQL Server 2000")
  {
    item = "InstallLocation";
    file = "\Binn\sqlservr.exe";
  }

  sqlFile = registry_get_sz(key:path ,item:item);
  if(!sqlFile){
    exit(0);
  }

  sqlFile += file;
  share = ereg_replace(pattern:"([A-Za-z]):.*", replace:"\1$", string:sqlFile);
  file = ereg_replace(pattern:"[A-Za-z]:(.*)", replace:"\1", string:sqlFile);

  fileVer = GetVer(file:file, share:share);
  if(!fileVer){
    return 0;
  }
  else return fileVer;
}


# Retrieving Microsoft SQL Server 2005 Registry entry
if(registry_key_exists(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                           "\Uninstall\Microsoft SQL Server 2005")){
  msSqlSer = "MS SQL Server 2005";
}
# Retrieving Microsoft SQL Server 2000 Registry entry
else if (registry_key_exists(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                  "\Uninstall\Microsoft SQL Server 2000")){
  msSqlSer = "MS SQL Server 2000";
}

if(!msSqlSer){
  exit(0);
}

if(msSqlSer == "MS SQL Server 2005")
{
  reqSqlVer = "2005.90.3077.0";
  insSqlVer = Get_FileVersion(ver:msSqlSer, path:"SOFTWARE\Microsoft" +
                                "\Microsoft SQL Server\MSSQL.1\Setup");
}
else if(msSqlSer == "MS SQL Server 2000")
{
  reqSqlVer = "2000.80.2055.0";
  insSqlVer = Get_FileVersion(ver:msSqlSer, path:"SOFTWARE\Microsoft\Windows" +
                        "\CurrentVersion\Uninstall\Microsoft SQL Server 2000");
}

if(!insSqlVer){
  exit(0);
}

if(version_is_less(version:insSqlVerr, test_version:reqSqlVer)){
  security_hole(mssqlPort);
}
