###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for pam_mount MDVSA-2008:208-1 (pam_mount)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830608);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:208-1");
  script_cve_id("CVE-2008-3970");
  script_name(english: "Mandriva Update for pam_mount MDVSA-2008:208-1 (pam_mount)");
  desc["english"] = "

  Vulnerability Insight:

  pam_mount 0.10 through 0.45, when luserconf is enabled, does not verify
  mountpoint and source ownership before mounting a user-defined volume,
  which allows local users to bypass intended access restrictions via
  a local mount.
  
  The updated packages have been patched to fix the issue.
  
  Update:
  
  The fix for CVE-2008-3970 uncovered crashes in the code handling the
  'allow', 'deny', and 'require' options in pam_mount-0.33, released
  for Mandriva Linux 2008 Spring. Also, the verification of the allowed
  mount options ('allow' configuration directive) was inverted in
  pam_mount-0.33.
  
  This update fixes these issues.

  Affected Software/OS:
  pam_mount on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-10/msg00029.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of pam_mount");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"pam_mount", rpm:"pam_mount~0.33~2.3mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}