###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for nasm MDVSA-2008:120 (nasm)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830439);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:120");
  script_cve_id("CVE-2008-2719");
  script_name(english: "Mandriva Update for nasm MDVSA-2008:120 (nasm)");
  desc["english"] = "

  Vulnerability Insight:

  An off-by-one error was found in nasm 2.02 that allowed
  context-dependent attackers to cause a denial of service (crash)
  or possibly execute arbitrary code via a crafted file that triggers
  a stack-based buffer overflow (CVE-2008-2719).
  
  The updated packages have been patched to prevent this issue.

  Affected Software/OS:
  nasm on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-06/msg00030.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of nasm");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"nasm", rpm:"nasm~2.02~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nasm-doc", rpm:"nasm-doc~2.02~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nasm-rdoff", rpm:"nasm-rdoff~2.02~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}