###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for autofs MDVSA-2008:009-1 (autofs)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830445);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:009-1");
  script_cve_id("CVE-2007-5964", "CVE-2007-6285");
  script_name(english: "Mandriva Update for autofs MDVSA-2008:009-1 (autofs)");
  desc["english"] = "

  Vulnerability Insight:

  The default behaviour of autofs 5 for the hosts map did not specify the
  nosuid and nodev mount options.  This could allow a local user with
  control of a remote NFS server to create a setuid root executable on
  the exported filesystem of the remote NFS server.  If this filesystem
  was mounted with the default hosts map, it would allow the user to
  obtain root privileges (CVE-2007-5964).  Likewise, the same scenario
  would be available for local users able to create device files on
  the exported filesystem which could allow the user to gain access to
  important system devices (CVE-2007-6285).
  
  Because the default behaviour of autofs was to mount -hosts map
  entries with the dev and suid options enabled by default, autofs has
  been altered to always use nodev and nosuid by default.  In order
  to have the old behaviour, the configuration must now explicitly set
  the dev and/or suid options.
  
  This change only affects the -hosts map which corresponds to the /net
  entry in the default configuration.
  
  Update:
  
  The previous update shipped with an incorrect LDAP lookup module
  that would prevent the automount daemon from starting.  This update
  corrects that problem.

  Affected Software/OS:
  autofs on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-01/msg00021.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of autofs");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"autofs", rpm:"autofs~5.0.2~8.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"autofs", rpm:"autofs~5.0.2~8.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}