###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for e2fsprogs MDVA-2008:007-1 (e2fsprogs)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830737);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:007-1");
  script_cve_id("");
  script_name(english: "Mandriva Update for e2fsprogs MDVA-2008:007-1 (e2fsprogs)");
  desc["english"] = "

  Vulnerability Insight:

  An incorrect Requires was added to the e2fsprogs package that prevented
  it from being installed properly on a system with both 32bit and
  64bit update media configured.  This update corrects the Requires,
  allowing the package to be installed properly.
  
  Update:
  
  The Requires that was used on the previous update was not explicit
  enough.  This update corrects that.

  Affected Software/OS:
  e2fsprogs on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-01/msg00016.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of e2fsprogs");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"e2fsprogs", rpm:"e2fsprogs~1.40.2~5.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libext2fs-devel", rpm:"libext2fs-devel~1.40.2~5.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libext2fs2", rpm:"libext2fs2~1.40.2~5.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ext2fs-devel", rpm:"lib64ext2fs-devel~1.40.2~5.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ext2fs2", rpm:"lib64ext2fs2~1.40.2~5.3mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}