###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for libnfsidmap MDKSA-2007:240 (libnfsidmap)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830039);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:240");
  script_cve_id("CVE-2007-4135");
  script_name(english: "Mandriva Update for libnfsidmap MDKSA-2007:240 (libnfsidmap)");
  desc["english"] = "

  Vulnerability Insight:

  The NFSv4 ID mapper prior to 0.17 did not properly handle return values
  from the getpwnam_r() function when performing a username lookup, which
  could cause it to report a file as being owned by 'root' instead of
  'nobody' if the file exists on the server but not the client.
  
  The updated packages have been patched to correct these issues.

  Affected Software/OS:
  libnfsidmap on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-12/msg00008.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libnfsidmap");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libnfsidmap0", rpm:"libnfsidmap0~0.17~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnfsidmap0-devel", rpm:"libnfsidmap0-devel~0.17~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnfsidmap", rpm:"libnfsidmap~0.17~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64nfsidmap0", rpm:"lib64nfsidmap0~0.17~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64nfsidmap0-devel", rpm:"lib64nfsidmap0-devel~0.17~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}