###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for xine-lib MDKSA-2007:062 (xine-lib)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830084);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:062");
  script_cve_id("CVE-2007-1387");
  script_name(english: "Mandriva Update for xine-lib MDKSA-2007:062 (xine-lib)");
  desc["english"] = "

  Vulnerability Insight:

  The DS_VideoDecoder_Open function in DirectShow/DS_VideoDecoder.c in
  xine-lib does not set the biSize before use in a memcpy, which allows
  user-assisted remote attackers to cause a buffer overflow and possibly
  execute arbitrary code.
  
  Updated packages have been patched to address this issue.

  Affected Software/OS:
  xine-lib on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-03/msg00015.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of xine-lib");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libxine1", rpm:"libxine1~1.1.2~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxine1-devel", rpm:"libxine1-devel~1.1.2~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-aa", rpm:"xine-aa~1.1.2~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-arts", rpm:"xine-arts~1.1.2~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-dxr3", rpm:"xine-dxr3~1.1.2~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-esd", rpm:"xine-esd~1.1.2~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-flac", rpm:"xine-flac~1.1.2~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-gnomevfs", rpm:"xine-gnomevfs~1.1.2~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-image", rpm:"xine-image~1.1.2~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-plugins", rpm:"xine-plugins~1.1.2~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-sdl", rpm:"xine-sdl~1.1.2~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-smb", rpm:"xine-smb~1.1.2~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xine-lib", rpm:"xine-lib~1.1.2~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xine1", rpm:"lib64xine1~1.1.2~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xine1-devel", rpm:"lib64xine1-devel~1.1.2~3.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}