###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for pulseaudio FEDORA-2008-0994
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860153);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-0994");
  script_cve_id("CVE-2008-0008");
  script_name(english: "Fedora Update for pulseaudio FEDORA-2008-0994");
  desc["english"] = "

  Vulnerability Insight:
  PulseAudio is a sound server for Linux and other Unix like operating
  systems. It is intended to be an improved drop-in replacement for the
  Enlightened Sound Daemon (ESOUND).


  Affected Software/OS:
  pulseaudio on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-January/msg00869.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of pulseaudio");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"pulseaudio", rpm:"pulseaudio~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-debuginfo", rpm:"pulseaudio-debuginfo~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-utils", rpm:"pulseaudio-utils~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-lib-devel", rpm:"pulseaudio-lib-devel~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-lib-zeroconf", rpm:"pulseaudio-lib-zeroconf~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-lib-glib2", rpm:"pulseaudio-lib-glib2~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-lib", rpm:"pulseaudio-lib~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-devel", rpm:"pulseaudio-devel~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-gconf", rpm:"pulseaudio-module-gconf~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-jack", rpm:"pulseaudio-module-jack~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-zeroconf", rpm:"pulseaudio-module-zeroconf~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-x11", rpm:"pulseaudio-module-x11~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-lirc", rpm:"pulseaudio-module-lirc~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-esound-compat", rpm:"pulseaudio-esound-compat~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio", rpm:"pulseaudio~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-debuginfo", rpm:"pulseaudio-debuginfo~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-utils", rpm:"pulseaudio-utils~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-lib-devel", rpm:"pulseaudio-lib-devel~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-lib-zeroconf", rpm:"pulseaudio-lib-zeroconf~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-lib-glib2", rpm:"pulseaudio-lib-glib2~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-lib", rpm:"pulseaudio-lib~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-devel", rpm:"pulseaudio-devel~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-gconf", rpm:"pulseaudio-module-gconf~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-jack", rpm:"pulseaudio-module-jack~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-zeroconf", rpm:"pulseaudio-module-zeroconf~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-x11", rpm:"pulseaudio-module-x11~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-lirc", rpm:"pulseaudio-module-lirc~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-esound-compat", rpm:"pulseaudio-esound-compat~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio", rpm:"pulseaudio~0.9.6~2.fc7.1", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}