###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for python-paramiko FEDORA-2008-0722
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860479);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-0722");
  script_cve_id("");
  script_name(english: "Fedora Update for python-paramiko FEDORA-2008-0722");
  desc["english"] = "

  Vulnerability Insight:
  Paramiko (a combination of the esperanto words for &quot;paranoid&quot; and &quot;friend&quot;) is
  a module for python 2.3 or greater that implements the SSH2 protocol for secure
  (encrypted and authenticated) connections to remote machines. Unlike SSL (aka
  TLS), the SSH2 protocol does not require heirarchical certificates signed by a
  powerful central authority. You may know SSH2 as the protocol that replaced
  telnet and rsh for secure access to remote shells, but the protocol also
  includes the ability to open arbitrary channels to remote services across an
  encrypted tunnel. (This is how sftp works, for example.)


  Affected Software/OS:
  python-paramiko on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-January/msg00594.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of python-paramiko");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"python-paramiko", rpm:"python-paramiko~1.7.1~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-paramiko", rpm:"python-paramiko~1.7.1~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}